/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.ext.group.gen.api;

import com.symphony.bdk.ext.group.gen.api.model.SortOrder;
import com.symphony.bdk.ext.group.gen.api.model.Status;
import com.symphony.bdk.ext.group.gen.api.model.Type;
import com.symphony.bdk.ext.group.gen.api.model.TypeList;
import com.symphony.bdk.http.api.ApiClient;
import com.symphony.bdk.http.api.ApiException;
import com.symphony.bdk.http.api.ApiResponse;
import com.symphony.bdk.http.api.util.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;

public class TypeApi {
    private ApiClient apiClient;

    public TypeApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Type getType(String xSymphonyHost, String typeId) throws ApiException {
        return (Type)this.getTypeWithHttpInfo(xSymphonyHost, typeId).getData();
    }

    public ApiResponse<Type> getTypeWithHttpInfo(String xSymphonyHost, String typeId) throws ApiException {
        Object localVarPostBody = null;
        if (xSymphonyHost == null) {
            throw new ApiException(400, "Missing the required parameter 'xSymphonyHost' when calling getType");
        }
        if (typeId == null) {
            throw new ApiException(400, "Missing the required parameter 'typeId' when calling getType");
        }
        String localVarPath = "/v1/types/{typeId}".replaceAll("\\{typeId\\}", this.apiClient.escapeString(typeId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (xSymphonyHost != null) {
            localVarHeaderParams.put("X-Symphony-Host", this.apiClient.parameterToString((Object)xSymphonyHost));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        TypeReference<Type> localVarReturnType = new TypeReference<Type>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (TypeReference)localVarReturnType);
    }

    public TypeList listTypes(String xSymphonyHost, Status status, String before, String after, Integer limit, SortOrder sortOrder) throws ApiException {
        return (TypeList)this.listTypesWithHttpInfo(xSymphonyHost, status, before, after, limit, sortOrder).getData();
    }

    public ApiResponse<TypeList> listTypesWithHttpInfo(String xSymphonyHost, Status status, String before, String after, Integer limit, SortOrder sortOrder) throws ApiException {
        Object localVarPostBody = null;
        if (xSymphonyHost == null) {
            throw new ApiException(400, "Missing the required parameter 'xSymphonyHost' when calling listTypes");
        }
        String localVarPath = "/v1/types";
        ArrayList localVarQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", (Object)status));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "before", (Object)before));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "after", (Object)after));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", (Object)limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sortOrder", (Object)sortOrder));
        if (xSymphonyHost != null) {
            localVarHeaderParams.put("X-Symphony-Host", this.apiClient.parameterToString((Object)xSymphonyHost));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        TypeReference<TypeList> localVarReturnType = new TypeReference<TypeList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (TypeReference)localVarReturnType);
    }
}

