/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.ext.group.gen.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.symphony.bdk.ext.group.gen.api.model.Owner;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A reduced set Group object, for retrieving list of group purpose")
@JsonPropertyOrder(value={"type", "ownerType", "ownerId", "name"})
public class BaseGroup {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    private Owner ownerType;
    public static final String JSON_PROPERTY_OWNER_ID = "ownerId";
    private Long ownerId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public BaseGroup type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="SDL", required=true, value="Group type identifier")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public BaseGroup ownerType(Owner ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Owner getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerType(Owner ownerType) {
        this.ownerType = ownerType;
    }

    public BaseGroup ownerId(Long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    @ApiModelProperty(example="100", required=true, value="Owner id if the owner type is tenant (podId) or user (userId), otherwise null")
    @JsonProperty(value="ownerId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getOwnerId() {
        return this.ownerId;
    }

    @JsonProperty(value="ownerId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public BaseGroup name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Test Group", required=true, value="Group's name")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseGroup baseGroup = (BaseGroup)o;
        return Objects.equals(this.type, baseGroup.type) && Objects.equals((Object)this.ownerType, (Object)baseGroup.ownerType) && Objects.equals(this.ownerId, baseGroup.ownerId) && Objects.equals(this.name, baseGroup.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.ownerType, this.ownerId, this.name});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseGroup {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    ownerId: ").append(this.toIndentedString(this.ownerId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

