/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.ext.group.gen.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.symphony.bdk.ext.group.gen.api.model.PaginationCursors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Pagination information")
@JsonPropertyOrder(value={"previous", "next", "cursors"})
public class Pagination {
    public static final String JSON_PROPERTY_PREVIOUS = "previous";
    private String previous;
    public static final String JSON_PROPERTY_NEXT = "next";
    private String next;
    public static final String JSON_PROPERTY_CURSORS = "cursors";
    private PaginationCursors cursors;

    public Pagination previous(String previous) {
        this.previous = previous;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path to retrieve the previous page of data. If not present, the current page is the first page of data.")
    @JsonProperty(value="previous")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrevious() {
        return this.previous;
    }

    @JsonProperty(value="previous")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrevious(String previous) {
        this.previous = previous;
    }

    public Pagination next(String next) {
        this.next = next;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path to retrieve the next page of data. If not present, the current page is the last page of data.")
    @JsonProperty(value="next")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNext() {
        return this.next;
    }

    @JsonProperty(value="next")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNext(String next) {
        this.next = next;
    }

    public Pagination cursors(PaginationCursors cursors) {
        this.cursors = cursors;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="cursors")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PaginationCursors getCursors() {
        return this.cursors;
    }

    @JsonProperty(value="cursors")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCursors(PaginationCursors cursors) {
        this.cursors = cursors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pagination pagination = (Pagination)o;
        return Objects.equals(this.previous, pagination.previous) && Objects.equals(this.next, pagination.next) && Objects.equals(this.cursors, pagination.cursors);
    }

    public int hashCode() {
        return Objects.hash(this.previous, this.next, this.cursors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pagination {\n");
        sb.append("    previous: ").append(this.toIndentedString(this.previous)).append("\n");
        sb.append("    next: ").append(this.toIndentedString(this.next)).append("\n");
        sb.append("    cursors: ").append(this.toIndentedString(this.cursors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

