/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.ext.group.gen.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.symphony.bdk.ext.group.gen.api.model.BaseProfile;
import com.symphony.bdk.ext.group.gen.api.model.GroupImplicitConnection;
import com.symphony.bdk.ext.group.gen.api.model.GroupInteractionTransfer;
import com.symphony.bdk.ext.group.gen.api.model.GroupVisibilityRestriction;
import com.symphony.bdk.ext.group.gen.api.model.Member;
import com.symphony.bdk.ext.group.gen.api.model.Owner;
import com.symphony.bdk.ext.group.gen.api.model.Status;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"type", "ownerType", "ownerId", "name", "subType", "referrer", "members", "profile", "visibilityRestriction", "implicitConnection", "interactionTransfer", "id", "status", "eTag"})
public class UpdateGroup {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    private Owner ownerType;
    public static final String JSON_PROPERTY_OWNER_ID = "ownerId";
    private Long ownerId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SUB_TYPE = "subType";
    private SubTypeEnum subType;
    public static final String JSON_PROPERTY_REFERRER = "referrer";
    private String referrer;
    public static final String JSON_PROPERTY_MEMBERS = "members";
    private List<Member> members = null;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private BaseProfile profile;
    public static final String JSON_PROPERTY_VISIBILITY_RESTRICTION = "visibilityRestriction";
    private GroupVisibilityRestriction visibilityRestriction;
    public static final String JSON_PROPERTY_IMPLICIT_CONNECTION = "implicitConnection";
    private GroupImplicitConnection implicitConnection;
    public static final String JSON_PROPERTY_INTERACTION_TRANSFER = "interactionTransfer";
    private GroupInteractionTransfer interactionTransfer;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_STATUS = "status";
    private Status status;
    public static final String JSON_PROPERTY_E_TAG = "eTag";
    private String eTag;

    public UpdateGroup type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="SDL", required=true, value="Group type identifier")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public UpdateGroup ownerType(Owner ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Owner getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerType(Owner ownerType) {
        this.ownerType = ownerType;
    }

    public UpdateGroup ownerId(Long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    @ApiModelProperty(example="100", required=true, value="Owner id if the owner type is tenant (podId) or user (userId), otherwise null")
    @JsonProperty(value="ownerId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getOwnerId() {
        return this.ownerId;
    }

    @JsonProperty(value="ownerId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public UpdateGroup name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Test Group", required=true, value="Group's name")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public UpdateGroup subType(SubTypeEnum subType) {
        this.subType = subType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="COMMUNITY", value="The type of the company group, This field is mandatory in case of a company group type, but not applicable for Symphony Distribution List")
    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubTypeEnum getSubType() {
        return this.subType;
    }

    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubType(SubTypeEnum subType) {
        this.subType = subType;
    }

    public UpdateGroup referrer(String referrer) {
        this.referrer = referrer;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Symphony, referring company name, referring channel partner name", value="The referring company name. This field is mandatory in case of a company group type, but not applicable for Symphony Distribution List")
    @JsonProperty(value="referrer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferrer() {
        return this.referrer;
    }

    @JsonProperty(value="referrer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferrer(String referrer) {
        this.referrer = referrer;
    }

    public UpdateGroup members(List<Member> members) {
        this.members = members;
        return this;
    }

    public UpdateGroup addMembersItem(Member membersItem) {
        if (this.members == null) {
            this.members = new ArrayList<Member>();
        }
        this.members.add(membersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="members")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Member> getMembers() {
        return this.members;
    }

    @JsonProperty(value="members")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMembers(List<Member> members) {
        this.members = members;
    }

    public UpdateGroup profile(BaseProfile profile) {
        this.profile = profile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BaseProfile getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(BaseProfile profile) {
        this.profile = profile;
    }

    public UpdateGroup visibilityRestriction(GroupVisibilityRestriction visibilityRestriction) {
        this.visibilityRestriction = visibilityRestriction;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="visibilityRestriction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GroupVisibilityRestriction getVisibilityRestriction() {
        return this.visibilityRestriction;
    }

    @JsonProperty(value="visibilityRestriction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVisibilityRestriction(GroupVisibilityRestriction visibilityRestriction) {
        this.visibilityRestriction = visibilityRestriction;
    }

    public UpdateGroup implicitConnection(GroupImplicitConnection implicitConnection) {
        this.implicitConnection = implicitConnection;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="implicitConnection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GroupImplicitConnection getImplicitConnection() {
        return this.implicitConnection;
    }

    @JsonProperty(value="implicitConnection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImplicitConnection(GroupImplicitConnection implicitConnection) {
        this.implicitConnection = implicitConnection;
    }

    public UpdateGroup interactionTransfer(GroupInteractionTransfer interactionTransfer) {
        this.interactionTransfer = interactionTransfer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="interactionTransfer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GroupInteractionTransfer getInteractionTransfer() {
        return this.interactionTransfer;
    }

    @JsonProperty(value="interactionTransfer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInteractionTransfer(GroupInteractionTransfer interactionTransfer) {
        this.interactionTransfer = interactionTransfer;
    }

    public UpdateGroup id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="60af77fd294165466ccdf510", value="Group's unique identifier")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public UpdateGroup status(Status status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(Status status) {
        this.status = status;
    }

    public UpdateGroup eTag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="e3a52e72-0854-4401-8c24-e0b17c0ca304", value="")
    @JsonProperty(value="eTag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String geteTag() {
        return this.eTag;
    }

    @JsonProperty(value="eTag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void seteTag(String eTag) {
        this.eTag = eTag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateGroup updateGroup = (UpdateGroup)o;
        return Objects.equals(this.type, updateGroup.type) && Objects.equals((Object)this.ownerType, (Object)updateGroup.ownerType) && Objects.equals(this.ownerId, updateGroup.ownerId) && Objects.equals(this.name, updateGroup.name) && Objects.equals((Object)this.subType, (Object)updateGroup.subType) && Objects.equals(this.referrer, updateGroup.referrer) && Objects.equals(this.members, updateGroup.members) && Objects.equals(this.profile, updateGroup.profile) && Objects.equals(this.visibilityRestriction, updateGroup.visibilityRestriction) && Objects.equals(this.implicitConnection, updateGroup.implicitConnection) && Objects.equals(this.interactionTransfer, updateGroup.interactionTransfer) && Objects.equals(this.id, updateGroup.id) && Objects.equals((Object)this.status, (Object)updateGroup.status) && Objects.equals(this.eTag, updateGroup.eTag);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.ownerType, this.ownerId, this.name, this.subType, this.referrer, this.members, this.profile, this.visibilityRestriction, this.implicitConnection, this.interactionTransfer, this.id, this.status, this.eTag});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateGroup {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    ownerId: ").append(this.toIndentedString(this.ownerId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    subType: ").append(this.toIndentedString((Object)this.subType)).append("\n");
        sb.append("    referrer: ").append(this.toIndentedString(this.referrer)).append("\n");
        sb.append("    members: ").append(this.toIndentedString(this.members)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    visibilityRestriction: ").append(this.toIndentedString(this.visibilityRestriction)).append("\n");
        sb.append("    implicitConnection: ").append(this.toIndentedString(this.implicitConnection)).append("\n");
        sb.append("    interactionTransfer: ").append(this.toIndentedString(this.interactionTransfer)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    eTag: ").append(this.toIndentedString(this.eTag)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SubTypeEnum {
        COMMUNITY("COMMUNITY"),
        CHANNEL("CHANNEL");

        private final String value;

        private SubTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SubTypeEnum fromValue(String value) {
            for (SubTypeEnum b : SubTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LoggerFactory.getLogger(SubTypeEnum.class).warn("Unexpected value '" + value + "', returning null.");
            return null;
        }
    }
}

