/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.ext.group.gen.api;

import com.symphony.bdk.ext.group.gen.api.model.AddMember;
import com.symphony.bdk.ext.group.gen.api.model.CreateGroup;
import com.symphony.bdk.ext.group.gen.api.model.GroupList;
import com.symphony.bdk.ext.group.gen.api.model.ReadGroup;
import com.symphony.bdk.ext.group.gen.api.model.SortOrder;
import com.symphony.bdk.ext.group.gen.api.model.Status;
import com.symphony.bdk.ext.group.gen.api.model.UpdateGroup;
import com.symphony.bdk.ext.group.gen.api.model.UploadAvatar;
import com.symphony.bdk.http.api.ApiClient;
import com.symphony.bdk.http.api.ApiException;
import com.symphony.bdk.http.api.ApiResponse;
import com.symphony.bdk.http.api.util.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;

public class GroupApi {
    private ApiClient apiClient;

    public GroupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ReadGroup addMemberToGroup(String xSymphonyHost, String groupId, AddMember addMember) throws ApiException {
        return (ReadGroup)this.addMemberToGroupWithHttpInfo(xSymphonyHost, groupId, addMember).getData();
    }

    public ApiResponse<ReadGroup> addMemberToGroupWithHttpInfo(String xSymphonyHost, String groupId, AddMember addMember) throws ApiException {
        AddMember localVarPostBody = addMember;
        if (xSymphonyHost == null) {
            throw new ApiException(400, "Missing the required parameter 'xSymphonyHost' when calling addMemberToGroup");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling addMemberToGroup");
        }
        if (addMember == null) {
            throw new ApiException(400, "Missing the required parameter 'addMember' when calling addMemberToGroup");
        }
        String localVarPath = "/v1/groups/{groupId}/member".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (xSymphonyHost != null) {
            localVarHeaderParams.put("X-Symphony-Host", this.apiClient.parameterToString((Object)xSymphonyHost));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        TypeReference<ReadGroup> localVarReturnType = new TypeReference<ReadGroup>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (TypeReference)localVarReturnType);
    }

    public GroupList deleteAllGroups(String xSymphonyHost) throws ApiException {
        return (GroupList)this.deleteAllGroupsWithHttpInfo(xSymphonyHost).getData();
    }

    public ApiResponse<GroupList> deleteAllGroupsWithHttpInfo(String xSymphonyHost) throws ApiException {
        Object localVarPostBody = null;
        if (xSymphonyHost == null) {
            throw new ApiException(400, "Missing the required parameter 'xSymphonyHost' when calling deleteAllGroups");
        }
        String localVarPath = "/v1/groups/deleteAll";
        ArrayList localVarQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (xSymphonyHost != null) {
            localVarHeaderParams.put("X-Symphony-Host", this.apiClient.parameterToString((Object)xSymphonyHost));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        TypeReference<GroupList> localVarReturnType = new TypeReference<GroupList>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (TypeReference)localVarReturnType);
    }

    public ReadGroup getGroup(String xSymphonyHost, String groupId) throws ApiException {
        return (ReadGroup)this.getGroupWithHttpInfo(xSymphonyHost, groupId).getData();
    }

    public ApiResponse<ReadGroup> getGroupWithHttpInfo(String xSymphonyHost, String groupId) throws ApiException {
        Object localVarPostBody = null;
        if (xSymphonyHost == null) {
            throw new ApiException(400, "Missing the required parameter 'xSymphonyHost' when calling getGroup");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling getGroup");
        }
        String localVarPath = "/v1/groups/{groupId}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (xSymphonyHost != null) {
            localVarHeaderParams.put("X-Symphony-Host", this.apiClient.parameterToString((Object)xSymphonyHost));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        TypeReference<ReadGroup> localVarReturnType = new TypeReference<ReadGroup>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (TypeReference)localVarReturnType);
    }

    public ReadGroup insertGroup(String xSymphonyHost, CreateGroup createGroup) throws ApiException {
        return (ReadGroup)this.insertGroupWithHttpInfo(xSymphonyHost, createGroup).getData();
    }

    public ApiResponse<ReadGroup> insertGroupWithHttpInfo(String xSymphonyHost, CreateGroup createGroup) throws ApiException {
        CreateGroup localVarPostBody = createGroup;
        if (xSymphonyHost == null) {
            throw new ApiException(400, "Missing the required parameter 'xSymphonyHost' when calling insertGroup");
        }
        if (createGroup == null) {
            throw new ApiException(400, "Missing the required parameter 'createGroup' when calling insertGroup");
        }
        String localVarPath = "/v1/groups";
        ArrayList localVarQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (xSymphonyHost != null) {
            localVarHeaderParams.put("X-Symphony-Host", this.apiClient.parameterToString((Object)xSymphonyHost));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        TypeReference<ReadGroup> localVarReturnType = new TypeReference<ReadGroup>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (TypeReference)localVarReturnType);
    }

    public GroupList listGroups(String xSymphonyHost, String typeId, Status status, String before, String after, Integer limit, SortOrder sortOrder) throws ApiException {
        return (GroupList)this.listGroupsWithHttpInfo(xSymphonyHost, typeId, status, before, after, limit, sortOrder).getData();
    }

    public ApiResponse<GroupList> listGroupsWithHttpInfo(String xSymphonyHost, String typeId, Status status, String before, String after, Integer limit, SortOrder sortOrder) throws ApiException {
        Object localVarPostBody = null;
        if (xSymphonyHost == null) {
            throw new ApiException(400, "Missing the required parameter 'xSymphonyHost' when calling listGroups");
        }
        if (typeId == null) {
            throw new ApiException(400, "Missing the required parameter 'typeId' when calling listGroups");
        }
        String localVarPath = "/v1/groups/type/{typeId}".replaceAll("\\{typeId\\}", this.apiClient.escapeString(typeId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", (Object)status));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "before", (Object)before));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "after", (Object)after));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", (Object)limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sortOrder", (Object)sortOrder));
        if (xSymphonyHost != null) {
            localVarHeaderParams.put("X-Symphony-Host", this.apiClient.parameterToString((Object)xSymphonyHost));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        TypeReference<GroupList> localVarReturnType = new TypeReference<GroupList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (TypeReference)localVarReturnType);
    }

    public ReadGroup updateAvatar(String xSymphonyHost, String groupId, UploadAvatar uploadAvatar) throws ApiException {
        return (ReadGroup)this.updateAvatarWithHttpInfo(xSymphonyHost, groupId, uploadAvatar).getData();
    }

    public ApiResponse<ReadGroup> updateAvatarWithHttpInfo(String xSymphonyHost, String groupId, UploadAvatar uploadAvatar) throws ApiException {
        UploadAvatar localVarPostBody = uploadAvatar;
        if (xSymphonyHost == null) {
            throw new ApiException(400, "Missing the required parameter 'xSymphonyHost' when calling updateAvatar");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling updateAvatar");
        }
        if (uploadAvatar == null) {
            throw new ApiException(400, "Missing the required parameter 'uploadAvatar' when calling updateAvatar");
        }
        String localVarPath = "/v1/groups/{groupId}/avatar".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (xSymphonyHost != null) {
            localVarHeaderParams.put("X-Symphony-Host", this.apiClient.parameterToString((Object)xSymphonyHost));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        TypeReference<ReadGroup> localVarReturnType = new TypeReference<ReadGroup>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (TypeReference)localVarReturnType);
    }

    public ReadGroup updateGroup(String xSymphonyHost, String ifMatch, String groupId, UpdateGroup updateGroup) throws ApiException {
        return (ReadGroup)this.updateGroupWithHttpInfo(xSymphonyHost, ifMatch, groupId, updateGroup).getData();
    }

    public ApiResponse<ReadGroup> updateGroupWithHttpInfo(String xSymphonyHost, String ifMatch, String groupId, UpdateGroup updateGroup) throws ApiException {
        UpdateGroup localVarPostBody = updateGroup;
        if (xSymphonyHost == null) {
            throw new ApiException(400, "Missing the required parameter 'xSymphonyHost' when calling updateGroup");
        }
        if (ifMatch == null) {
            throw new ApiException(400, "Missing the required parameter 'ifMatch' when calling updateGroup");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling updateGroup");
        }
        if (updateGroup == null) {
            throw new ApiException(400, "Missing the required parameter 'updateGroup' when calling updateGroup");
        }
        String localVarPath = "/v1/groups/{groupId}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        ArrayList localVarQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (xSymphonyHost != null) {
            localVarHeaderParams.put("X-Symphony-Host", this.apiClient.parameterToString((Object)xSymphonyHost));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString((Object)ifMatch));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        TypeReference<ReadGroup> localVarReturnType = new TypeReference<ReadGroup>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (TypeReference)localVarReturnType);
    }
}

