/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.ext.group.gen.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Common error response body")
@JsonPropertyOrder(value={"code", "message", "context", "details"})
public class Error {
    public static final String JSON_PROPERTY_CODE = "code";
    private String code;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_CONTEXT = "context";
    private Map<String, String> context = null;
    public static final String JSON_PROPERTY_DETAILS = "details";
    private Object details;

    public Error code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(required=true, value="An internal code that can be used by support/developers to quickly locate the line of code that generated the error response.")
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCode() {
        return this.code;
    }

    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCode(String code) {
        this.code = code;
    }

    public Error message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(required=true, value="A human-readable error message")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMessage(String message) {
        this.message = message;
    }

    public Error context(Map<String, String> context) {
        this.context = context;
        return this;
    }

    public Error putContextItem(String key, String contextItem) {
        if (this.context == null) {
            this.context = new HashMap<String, String>();
        }
        this.context.put(key, contextItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A name-value map of variables and their value necessary to construct the message")
    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public Error details(Object details) {
        this.details = details;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Additional data that might be included")
    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getDetails() {
        return this.details;
    }

    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDetails(Object details) {
        this.details = details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals(this.code, error.code) && Objects.equals(this.message, error.message) && Objects.equals(this.context, error.context) && Objects.equals(this.details, error.details);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message, this.context, this.details);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

