/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.ext.group.gen.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.symphony.bdk.ext.group.gen.api.model.GroupImplicitConnection;
import com.symphony.bdk.ext.group.gen.api.model.GroupInteractionTransfer;
import com.symphony.bdk.ext.group.gen.api.model.GroupVisibilityRestriction;
import com.symphony.bdk.ext.group.gen.api.model.Owner;
import com.symphony.bdk.ext.group.gen.api.model.Profile;
import com.symphony.bdk.ext.group.gen.api.model.ReadMember;
import com.symphony.bdk.ext.group.gen.api.model.Status;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"type", "ownerType", "ownerId", "name", "id", "createdDate", "createdBy", "updatedDate", "updatedBy", "status", "eTag", "subType", "referrer", "members", "profile", "visibilityRestriction", "implicitConnection", "interactionTransfer"})
public class ReadGroup {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
    private Owner ownerType;
    public static final String JSON_PROPERTY_OWNER_ID = "ownerId";
    private Long ownerId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private OffsetDateTime createdDate;
    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    private String createdBy;
    public static final String JSON_PROPERTY_UPDATED_DATE = "updatedDate";
    private OffsetDateTime updatedDate;
    public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
    private String updatedBy;
    public static final String JSON_PROPERTY_STATUS = "status";
    private Status status;
    public static final String JSON_PROPERTY_E_TAG = "eTag";
    private String eTag;
    public static final String JSON_PROPERTY_SUB_TYPE = "subType";
    private SubTypeEnum subType;
    public static final String JSON_PROPERTY_REFERRER = "referrer";
    private String referrer;
    public static final String JSON_PROPERTY_MEMBERS = "members";
    private List<ReadMember> members = null;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Profile profile;
    public static final String JSON_PROPERTY_VISIBILITY_RESTRICTION = "visibilityRestriction";
    private GroupVisibilityRestriction visibilityRestriction;
    public static final String JSON_PROPERTY_IMPLICIT_CONNECTION = "implicitConnection";
    private GroupImplicitConnection implicitConnection;
    public static final String JSON_PROPERTY_INTERACTION_TRANSFER = "interactionTransfer";
    private GroupInteractionTransfer interactionTransfer;

    public ReadGroup type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="SDL", required=true, value="Group type identifier")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public ReadGroup ownerType(Owner ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Owner getOwnerType() {
        return this.ownerType;
    }

    @JsonProperty(value="ownerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerType(Owner ownerType) {
        this.ownerType = ownerType;
    }

    public ReadGroup ownerId(Long ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    @ApiModelProperty(example="100", required=true, value="Owner id if the owner type is tenant (podId) or user (userId), otherwise null")
    @JsonProperty(value="ownerId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getOwnerId() {
        return this.ownerId;
    }

    @JsonProperty(value="ownerId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public ReadGroup name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Test Group", required=true, value="Group's name")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public ReadGroup id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Group's unique identifier")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public ReadGroup createdDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public ReadGroup createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public ReadGroup updatedDate(OffsetDateTime updatedDate) {
        this.updatedDate = updatedDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="updatedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedDate() {
        return this.updatedDate;
    }

    @JsonProperty(value="updatedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedDate(OffsetDateTime updatedDate) {
        this.updatedDate = updatedDate;
    }

    public ReadGroup updatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public ReadGroup status(Status status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(Status status) {
        this.status = status;
    }

    public ReadGroup eTag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="e3a52e72-0854-4401-8c24-e0b17c0ca304", value="")
    @JsonProperty(value="eTag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String geteTag() {
        return this.eTag;
    }

    @JsonProperty(value="eTag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void seteTag(String eTag) {
        this.eTag = eTag;
    }

    public ReadGroup subType(SubTypeEnum subType) {
        this.subType = subType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="COMMUNITY", value="The type of the company group, This field is mandatory in case of a company group type, but not applicable for Symphony Distribution List")
    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SubTypeEnum getSubType() {
        return this.subType;
    }

    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubType(SubTypeEnum subType) {
        this.subType = subType;
    }

    public ReadGroup referrer(String referrer) {
        this.referrer = referrer;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Symphony, referring company name, referring channel partner name", value="The referring company name. This field is mandatory in case of a company group type, but not applicable for Symphony Distribution List")
    @JsonProperty(value="referrer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferrer() {
        return this.referrer;
    }

    @JsonProperty(value="referrer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferrer(String referrer) {
        this.referrer = referrer;
    }

    public ReadGroup members(List<ReadMember> members) {
        this.members = members;
        return this;
    }

    public ReadGroup addMembersItem(ReadMember membersItem) {
        if (this.members == null) {
            this.members = new ArrayList<ReadMember>();
        }
        this.members.add(membersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="members")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ReadMember> getMembers() {
        return this.members;
    }

    @JsonProperty(value="members")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMembers(List<ReadMember> members) {
        this.members = members;
    }

    public ReadGroup profile(Profile profile) {
        this.profile = profile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Profile getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public ReadGroup visibilityRestriction(GroupVisibilityRestriction visibilityRestriction) {
        this.visibilityRestriction = visibilityRestriction;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="visibilityRestriction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GroupVisibilityRestriction getVisibilityRestriction() {
        return this.visibilityRestriction;
    }

    @JsonProperty(value="visibilityRestriction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVisibilityRestriction(GroupVisibilityRestriction visibilityRestriction) {
        this.visibilityRestriction = visibilityRestriction;
    }

    public ReadGroup implicitConnection(GroupImplicitConnection implicitConnection) {
        this.implicitConnection = implicitConnection;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="implicitConnection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GroupImplicitConnection getImplicitConnection() {
        return this.implicitConnection;
    }

    @JsonProperty(value="implicitConnection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImplicitConnection(GroupImplicitConnection implicitConnection) {
        this.implicitConnection = implicitConnection;
    }

    public ReadGroup interactionTransfer(GroupInteractionTransfer interactionTransfer) {
        this.interactionTransfer = interactionTransfer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="interactionTransfer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GroupInteractionTransfer getInteractionTransfer() {
        return this.interactionTransfer;
    }

    @JsonProperty(value="interactionTransfer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInteractionTransfer(GroupInteractionTransfer interactionTransfer) {
        this.interactionTransfer = interactionTransfer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadGroup readGroup = (ReadGroup)o;
        return Objects.equals(this.type, readGroup.type) && Objects.equals((Object)this.ownerType, (Object)readGroup.ownerType) && Objects.equals(this.ownerId, readGroup.ownerId) && Objects.equals(this.name, readGroup.name) && Objects.equals(this.id, readGroup.id) && Objects.equals(this.createdDate, readGroup.createdDate) && Objects.equals(this.createdBy, readGroup.createdBy) && Objects.equals(this.updatedDate, readGroup.updatedDate) && Objects.equals(this.updatedBy, readGroup.updatedBy) && Objects.equals((Object)this.status, (Object)readGroup.status) && Objects.equals(this.eTag, readGroup.eTag) && Objects.equals((Object)this.subType, (Object)readGroup.subType) && Objects.equals(this.referrer, readGroup.referrer) && Objects.equals(this.members, readGroup.members) && Objects.equals(this.profile, readGroup.profile) && Objects.equals(this.visibilityRestriction, readGroup.visibilityRestriction) && Objects.equals(this.implicitConnection, readGroup.implicitConnection) && Objects.equals(this.interactionTransfer, readGroup.interactionTransfer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.ownerType, this.ownerId, this.name, this.id, this.createdDate, this.createdBy, this.updatedDate, this.updatedBy, this.status, this.eTag, this.subType, this.referrer, this.members, this.profile, this.visibilityRestriction, this.implicitConnection, this.interactionTransfer});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReadGroup {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    ownerType: ").append(this.toIndentedString((Object)this.ownerType)).append("\n");
        sb.append("    ownerId: ").append(this.toIndentedString(this.ownerId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    updatedDate: ").append(this.toIndentedString(this.updatedDate)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    eTag: ").append(this.toIndentedString(this.eTag)).append("\n");
        sb.append("    subType: ").append(this.toIndentedString((Object)this.subType)).append("\n");
        sb.append("    referrer: ").append(this.toIndentedString(this.referrer)).append("\n");
        sb.append("    members: ").append(this.toIndentedString(this.members)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    visibilityRestriction: ").append(this.toIndentedString(this.visibilityRestriction)).append("\n");
        sb.append("    implicitConnection: ").append(this.toIndentedString(this.implicitConnection)).append("\n");
        sb.append("    interactionTransfer: ").append(this.toIndentedString(this.interactionTransfer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SubTypeEnum {
        COMMUNITY("COMMUNITY"),
        CHANNEL("CHANNEL");

        private final String value;

        private SubTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SubTypeEnum fromValue(String value) {
            for (SubTypeEnum b : SubTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LoggerFactory.getLogger(SubTypeEnum.class).warn("Unexpected value '" + value + "', returning null.");
            return null;
        }
    }
}

