/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.app.spring.auth;

import com.symphony.bdk.app.spring.SymphonyBdkAppProperties;
import com.symphony.bdk.app.spring.auth.model.AppToken;
import com.symphony.bdk.app.spring.auth.model.JwtInfo;
import com.symphony.bdk.app.spring.auth.model.TokenPair;
import com.symphony.bdk.app.spring.auth.model.UserId;
import com.symphony.bdk.app.spring.auth.service.CircleOfTrustService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bdk/v1/app"})
public class CircleOfTrustController {
    private static final Logger log = LoggerFactory.getLogger(CircleOfTrustController.class);
    private final SymphonyBdkAppProperties properties;
    private final CircleOfTrustService circleOfTrustService;

    @PostMapping(value={"/auth"})
    public AppToken authenticate() {
        log.debug("Generate app token and use it to authenticate the extension app.");
        return this.circleOfTrustService.authenticate();
    }

    @PostMapping(value={"/tokens"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void validateTokens(@Valid @RequestBody TokenPair tokenPair) {
        log.debug("Validate the pair of tokens: app token and Symphony token.");
        this.circleOfTrustService.validateTokens(tokenPair);
    }

    @PostMapping(value={"/jwt"})
    public UserId validateJwt(@Valid @RequestBody JwtInfo jwtInfo, HttpServletRequest request, HttpServletResponse response) {
        log.debug("Validate the jwt signed by extension app frontend to get the user id");
        String jwt = jwtInfo.jwt();
        UserId userId = this.circleOfTrustService.validateJwt(jwt);
        if (this.properties.getAuth().getJwtCookie().getEnabled().booleanValue()) {
            response.addHeader("Set-Cookie", this.jwtCookie(jwt, request.getContextPath()).toString());
        }
        return userId;
    }

    private ResponseCookie jwtCookie(String jwt, String path) {
        int maxAgeInSeconds = (int)this.properties.getAuth().getJwtCookie().getMaxAge().getSeconds();
        String sameSite = this.properties.getAuth().getJwtCookie().getSameSite();
        log.debug("Creating JWT cookie: maxAge={}s", (Object)maxAgeInSeconds);
        return ResponseCookie.from((String)"userJwt", (String)jwt).maxAge((long)maxAgeInSeconds).secure(true).httpOnly(true).path(path).sameSite(sameSite).build();
    }

    public CircleOfTrustController(SymphonyBdkAppProperties properties, CircleOfTrustService circleOfTrustService) {
        this.properties = properties;
        this.circleOfTrustService = circleOfTrustService;
    }
}

