/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.app.spring.auth.service;

import com.symphony.bdk.app.spring.auth.model.AppToken;
import com.symphony.bdk.app.spring.auth.model.TokenPair;
import com.symphony.bdk.app.spring.auth.model.UserId;
import com.symphony.bdk.app.spring.exception.BdkAppErrorCode;
import com.symphony.bdk.app.spring.exception.BdkAppException;
import com.symphony.bdk.core.auth.AppAuthSession;
import com.symphony.bdk.core.auth.ExtensionAppAuthenticator;
import com.symphony.bdk.core.auth.exception.AuthInitializationException;
import com.symphony.bdk.core.auth.exception.AuthUnauthorizedException;
import com.symphony.bdk.core.auth.jwt.UserClaim;
import com.symphony.bdk.spring.SymphonyBdkCoreProperties;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Hex;
import org.springframework.stereotype.Service;

@Service
public class CircleOfTrustService {
    private static final SecureRandom secureRandom = new SecureRandom();
    private final ExtensionAppAuthenticator authenticator;
    private final SymphonyBdkCoreProperties properties;

    public AppToken authenticate() {
        try {
            AppAuthSession authSession = this.authenticator.authenticateExtensionApp(this.generateToken());
            return new AppToken(authSession.getAppToken());
        }
        catch (AuthUnauthorizedException e) {
            throw new BdkAppException(BdkAppErrorCode.AUTH_FAILURE, (Exception)((Object)e), this.properties.getApp().getAppId());
        }
    }

    public void validateTokens(TokenPair tokenPair) {
        if (!this.authenticator.validateTokens(tokenPair.appToken(), tokenPair.symphonyToken())) {
            throw new BdkAppException(BdkAppErrorCode.INVALID_TOKEN, new String[0]);
        }
    }

    public UserId validateJwt(String jwt) {
        try {
            UserClaim userClaim = this.authenticator.validateJwt(jwt);
            return new UserId(userClaim.getId());
        }
        catch (AuthInitializationException e) {
            throw new BdkAppException(BdkAppErrorCode.INVALID_JWT, (Exception)((Object)e), new String[0]);
        }
    }

    private String generateToken() {
        byte[] randBytes = new byte[64];
        secureRandom.nextBytes(randBytes);
        return Hex.encodeHexString((byte[])randBytes);
    }

    public CircleOfTrustService(ExtensionAppAuthenticator authenticator, SymphonyBdkCoreProperties properties) {
        this.authenticator = authenticator;
        this.properties = properties;
    }
}

