/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.app.spring.config;

import com.symphony.bdk.app.spring.SymphonyBdkAppProperties;
import com.symphony.bdk.app.spring.properties.CorsProperties;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

public class BdkExtAppSecurityConfig {
    private static final Logger log = LoggerFactory.getLogger(BdkExtAppSecurityConfig.class);
    private final SymphonyBdkAppProperties properties;

    @Bean
    public List<CorsFilter> corsFilters() {
        return this.properties.getCors().keySet().stream().map(mapping -> {
            CorsProperties props = this.properties.getCors().get(mapping);
            CorsConfiguration config = new CorsConfiguration();
            config.setAllowedOrigins(props.getAllowedOrigins());
            config.setAllowedHeaders(props.getAllowedHeaders());
            config.setAllowedMethods(props.getAllowedMethods());
            config.setExposedHeaders(props.getExposedHeaders());
            config.setAllowCredentials(props.getAllowCredentials());
            UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
            source.registerCorsConfiguration(mapping, config);
            return new CorsFilter((CorsConfigurationSource)source);
        }).toList();
    }

    public BdkExtAppSecurityConfig(SymphonyBdkAppProperties properties) {
        this.properties = properties;
    }
}

