/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.app.spring.config;

import com.symphony.bdk.app.spring.SymphonyBdkAppProperties;
import com.symphony.bdk.app.spring.filter.TracingFilter;
import jakarta.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(name={"bdk-app.tracing.enabled"}, havingValue="true", matchIfMissing=true)
public class BdkExtAppTracingFilterConfig {
    @Bean
    public FilterRegistrationBean<TracingFilter> tracingFilter(SymphonyBdkAppProperties properties) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new TracingFilter());
        registrationBean.addUrlPatterns(BdkExtAppTracingFilterConfig.getUrlPatterns(properties));
        registrationBean.setOrder(Integer.MIN_VALUE);
        return registrationBean;
    }

    private static String[] getUrlPatterns(SymphonyBdkAppProperties properties) {
        return properties.getTracing().getUrlPatterns().toArray(new String[0]);
    }
}

