/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.app.spring.exception;

import com.symphony.bdk.app.spring.exception.BdkAppError;
import com.symphony.bdk.app.spring.exception.BdkAppErrorCode;
import com.symphony.bdk.app.spring.exception.BdkAppException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class GlobalControllerExceptionHandler
extends ResponseEntityExceptionHandler {
    @ExceptionHandler(value={BdkAppException.class})
    public ResponseEntity<Object> handleBdkAppException(BdkAppException e, WebRequest request) {
        BdkAppError error = BdkAppError.fromException(e);
        return super.handleExceptionInternal((Exception)e, (Object)error, new HttpHeaders(), (HttpStatusCode)e.getErrorCode().getStatus(), request);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        BdkAppError error = new BdkAppError();
        error.setCode(BdkAppErrorCode.MISSING_FIELDS);
        List<String> errors = ex.getBindingResult().getFieldErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList());
        error.setMessage(errors);
        return super.handleExceptionInternal((Exception)ex, (Object)error, headers, (HttpStatusCode)HttpStatus.BAD_REQUEST, request);
    }
}

