/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.app.spring.filter;

import com.symphony.bdk.http.api.tracing.DistributedTracingContext;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(TracingFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String xTraceInHeader = request.getHeader("X-Trace-Id");
        if (xTraceInHeader == null || xTraceInHeader.isEmpty()) {
            DistributedTracingContext.setTraceId();
        } else {
            DistributedTracingContext.setBaseTraceId((String)xTraceInHeader);
        }
        response.setHeader("X-Trace-Id", DistributedTracingContext.getTraceId());
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            DistributedTracingContext.clear();
        }
    }
}

