/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.app.spring.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.symphony.bdk.core.service.health.HealthService;
import com.symphony.bdk.gen.api.model.V3Health;
import com.symphony.bdk.gen.api.model.V3HealthComponent;
import com.symphony.bdk.gen.api.model.V3HealthStatus;
import com.symphony.bdk.http.api.ApiRuntimeException;
import java.util.Map;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

@API(status=API.Status.INTERNAL)
public class SymphonyBdkHealthIndicator
extends AbstractHealthIndicator {
    private static final Logger log = LoggerFactory.getLogger(SymphonyBdkHealthIndicator.class);
    public static final String DOWN = "DOWN";
    public static final String WARNING = "WARNING";
    private final HealthService healthService;
    private static final String POD = "pod";
    private static final String DF = "datafeed";
    private static final String KM = "key_manager";
    private static final String AGT = "agentservice";
    private static final String CE = "ceservice";
    private static final String DFL = "datafeedloop";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public SymphonyBdkHealthIndicator(HealthService healthService) {
        this.healthService = healthService;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            V3Health health = this.healthService.healthCheckExtended();
            this.buildHealthDetail(builder, health);
        }
        catch (ApiRuntimeException e) {
            log.debug("Health check failed, trying to parse the failure response body.", (Throwable)e);
            log.trace("Health check failure response body - {}", (Object)e.getResponseBody());
            try {
                V3Health health = (V3Health)MAPPER.readValue(e.getResponseBody(), V3Health.class);
                this.buildHealthDetail(builder, health);
            }
            catch (JsonProcessingException exception) {
                log.debug("Failed to parse the health check failure response body, assume the global health state is down.", (Throwable)e);
                this.buildHealthDownDetail(builder);
            }
        }
    }

    private void buildHealthDetail(Health.Builder builder, V3Health health) {
        Map services = health.getServices();
        Map users = health.getUsers();
        V3HealthStatus podStatus = ((V3HealthComponent)services.get(POD)).getStatus();
        V3HealthStatus dfStatus = ((V3HealthComponent)services.get(DF)).getStatus();
        V3HealthStatus kmStatus = ((V3HealthComponent)services.get(KM)).getStatus();
        V3HealthStatus agtStatus = ((V3HealthComponent)users.get(AGT)).getStatus();
        V3HealthStatus datafeedLoop = this.healthService.datafeedHealthCheck();
        boolean global = podStatus == V3HealthStatus.UP && dfStatus == V3HealthStatus.UP && kmStatus == V3HealthStatus.UP && agtStatus == V3HealthStatus.UP && datafeedLoop == V3HealthStatus.UP;
        builder.status(global ? Status.UP.getCode() : WARNING).withDetail(POD, services.get(POD)).withDetail(DF, services.get(DF)).withDetail(KM, services.get(KM)).withDetail(AGT, users.get(AGT)).withDetail(CE, users.get(CE)).withDetail(DFL, (Object)datafeedLoop);
    }

    private void buildHealthDownDetail(Health.Builder builder) {
        builder.status(DOWN).withDetail(POD, (Object)DOWN).withDetail(DF, (Object)DOWN).withDetail(KM, (Object)DOWN).withDetail(AGT, (Object)DOWN).withDetail(CE, (Object)DOWN).withDetail(DFL, (Object)DOWN);
    }
}

