/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.core.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.symphony.bdk.core.config.BdkConfigParser;
import com.symphony.bdk.core.config.exception.BdkConfigException;
import com.symphony.bdk.core.config.legacy.LegacyConfigMapper;
import com.symphony.bdk.core.config.legacy.model.LegacySymConfig;
import com.symphony.bdk.core.config.model.BdkConfig;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class BdkConfigLoader {
    private static final Logger log = LoggerFactory.getLogger(BdkConfigLoader.class);
    private static final ObjectMapper JSON_MAPPER = new JsonMapper();
    private static final JavaPropsMapper PROPS_MAPPER = new JavaPropsMapper();

    public static BdkConfig loadFromFile(String configPath) throws BdkConfigException {
        try {
            FileInputStream inputStream = new FileInputStream(configPath);
            return BdkConfigLoader.loadFromInputStream(inputStream);
        }
        catch (FileNotFoundException e) {
            throw new BdkConfigException("Config file has not been found from location: " + configPath, e);
        }
    }

    public static BdkConfig loadFromInputStream(InputStream inputStream) throws BdkConfigException {
        BdkConfigParser parser = new BdkConfigParser();
        return BdkConfigLoader.parseConfig(parser.parse(inputStream));
    }

    private static BdkConfig parseConfig(JsonNode jsonNode) {
        if (jsonNode.at("/botUsername").isMissingNode()) {
            return (BdkConfig)JSON_MAPPER.convertValue((Object)jsonNode, BdkConfig.class);
        }
        LegacySymConfig legacySymConfig = (LegacySymConfig)JSON_MAPPER.convertValue((Object)jsonNode, LegacySymConfig.class);
        return LegacyConfigMapper.map(legacySymConfig);
    }

    @Generated
    public static BdkConfig loadFromSymphonyDir(String relPath) throws BdkConfigException {
        String home = System.getProperty("user.home");
        Path symphonyDirPath = Paths.get(home, ".symphony");
        Path configPath = symphonyDirPath.resolve(relPath);
        log.debug("Loading configuration from the Symphony directory : {}", (Object)configPath);
        try {
            return BdkConfigLoader.loadFromInputStream(new FileInputStream(configPath.toFile()));
        }
        catch (FileNotFoundException e) {
            throw new BdkConfigException("Unable to load configuration from the .symphony directory with relative location: " + relPath, e);
        }
    }

    public static BdkConfig loadFromClasspath(String configPath) throws BdkConfigException {
        InputStream inputStream = BdkConfigLoader.class.getResourceAsStream(configPath);
        if (inputStream != null) {
            return BdkConfigLoader.loadFromInputStream(inputStream);
        }
        throw new BdkConfigException("Config file has not found from classpath location: " + configPath);
    }

    public static BdkConfig loadFromProperties(Properties properties) throws IOException {
        Properties propertyMap = properties;
        return BdkConfigLoader.loadFromPropertyMap(propertyMap);
    }

    public static BdkConfig loadFromPropertyMap(Map<String, String> properties) throws IOException {
        return (BdkConfig)PROPS_MAPPER.readMapAs(properties, BdkConfig.class);
    }

    static {
        PROPS_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JSON_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

