/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.core.config.model;

import org.apache.commons.lang3.ObjectUtils;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class BdkRsaKeyConfig {
    private static final Logger log = LoggerFactory.getLogger(BdkRsaKeyConfig.class);
    private String path;
    private byte[] content;

    public boolean isConfigured() {
        if (ObjectUtils.isNotEmpty((Object)this.path) && ObjectUtils.isNotEmpty((Object)this.content)) {
            log.error("Found both \"content\" and \"path\" field while configuring RSA authentication, only one is allowed");
            return false;
        }
        return ObjectUtils.isNotEmpty((Object)this.path) || ObjectUtils.isNotEmpty((Object)this.content);
    }

    public boolean isValid() {
        return !ObjectUtils.isNotEmpty((Object)this.path) || !ObjectUtils.isNotEmpty((Object)this.content);
    }

    public String getPath() {
        return this.path;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }
}

