/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.core.config.model;

import com.symphony.bdk.core.config.model.BdkAgentConfig;
import com.symphony.bdk.core.config.model.BdkBotConfig;
import com.symphony.bdk.core.config.model.BdkClientConfig;
import com.symphony.bdk.core.config.model.BdkCommonJwtConfig;
import com.symphony.bdk.core.config.model.BdkDatafeedConfig;
import com.symphony.bdk.core.config.model.BdkExtAppConfig;
import com.symphony.bdk.core.config.model.BdkRetryConfig;
import com.symphony.bdk.core.config.model.BdkServerConfig;
import com.symphony.bdk.core.config.model.BdkSslConfig;
import org.apache.commons.lang3.StringUtils;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public class BdkConfig
extends BdkServerConfig {
    private BdkAgentConfig agent = new BdkAgentConfig(this);
    private BdkClientConfig pod = new BdkClientConfig(this);
    private BdkClientConfig keyManager = new BdkClientConfig(this);
    private BdkClientConfig sessionAuth = new BdkClientConfig(this);
    private BdkBotConfig bot = new BdkBotConfig();
    private BdkExtAppConfig app = new BdkExtAppConfig();
    private BdkSslConfig ssl = new BdkSslConfig();
    private BdkRetryConfig retry = new BdkRetryConfig();
    private BdkDatafeedConfig datafeed = new BdkDatafeedConfig();
    private BdkCommonJwtConfig commonJwt = new BdkCommonJwtConfig();

    public boolean isOboConfigured() {
        return this.app.isConfigured();
    }

    public boolean isBotConfigured() {
        return this.bot != null && StringUtils.isNotEmpty((CharSequence)this.bot.getUsername());
    }

    public boolean isCommonJwtEnabled() {
        return this.getCommonJwt().getEnabled();
    }

    public BdkRetryConfig getDatafeedRetryConfig() {
        return this.datafeed.getRetry() == null ? this.retry : this.datafeed.getRetry();
    }

    public void setAgent(BdkAgentConfig agent) {
        this.agent = this.attachParent(agent);
    }

    public void setPod(BdkClientConfig pod) {
        this.pod = this.attachParent(pod);
    }

    public void setKeyManager(BdkClientConfig keyManager) {
        this.keyManager = this.attachParent(keyManager);
    }

    public void setSessionAuth(BdkClientConfig sessionAuth) {
        this.sessionAuth = this.attachParent(sessionAuth);
    }

    private <T extends BdkClientConfig> T attachParent(T config) {
        config.setParentConfig(this);
        return config;
    }

    public BdkAgentConfig getAgent() {
        return this.agent;
    }

    public BdkClientConfig getPod() {
        return this.pod;
    }

    public BdkClientConfig getKeyManager() {
        return this.keyManager;
    }

    public BdkClientConfig getSessionAuth() {
        return this.sessionAuth;
    }

    public BdkBotConfig getBot() {
        return this.bot;
    }

    public BdkExtAppConfig getApp() {
        return this.app;
    }

    public BdkSslConfig getSsl() {
        return this.ssl;
    }

    public BdkRetryConfig getRetry() {
        return this.retry;
    }

    public BdkDatafeedConfig getDatafeed() {
        return this.datafeed;
    }

    public BdkCommonJwtConfig getCommonJwt() {
        return this.commonJwt;
    }

    public void setBot(BdkBotConfig bot) {
        this.bot = bot;
    }

    public void setApp(BdkExtAppConfig app) {
        this.app = app;
    }

    public void setSsl(BdkSslConfig ssl) {
        this.ssl = ssl;
    }

    public void setRetry(BdkRetryConfig retry) {
        this.retry = retry;
    }

    public void setDatafeed(BdkDatafeedConfig datafeed) {
        this.datafeed = datafeed;
    }

    public void setCommonJwt(BdkCommonJwtConfig commonJwt) {
        this.commonJwt = commonJwt;
    }
}

