/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.core.config.model;

import com.symphony.bdk.core.config.model.BdkProxyConfig;
import java.util.Map;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public class BdkServerConfig {
    protected static final String DEFAULT_SCHEME = "https";
    protected static final int DEFAULT_HTTPS_PORT = 443;
    protected BdkProxyConfig proxy;
    protected String scheme = "https";
    protected String host;
    protected Integer port = 443;
    protected String context = "";
    protected Integer connectionTimeout;
    protected Integer readTimeout;
    protected Integer connectionPoolMax;
    protected Integer connectionPoolPerRoute;
    protected Map<String, String> defaultHeaders;

    public String getBasePath() {
        return this.getScheme() + "://" + this.getHost() + this.getPortAsString() + this.getFormattedContext();
    }

    public String getFormattedContext() {
        String localContext = this.getContext();
        if (localContext == null) {
            return "";
        }
        if (!localContext.equals("") && localContext.charAt(0) != '/') {
            return "/" + localContext;
        }
        if (!localContext.equals("") && localContext.endsWith("/")) {
            return localContext.substring(0, localContext.length() - 1);
        }
        return localContext;
    }

    private String getPortAsString() {
        return this.getPort() != null ? ":" + this.getPort() : "";
    }

    public BdkProxyConfig getProxy() {
        return this.proxy;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getContext() {
        return this.context;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public Integer getConnectionPoolMax() {
        return this.connectionPoolMax;
    }

    public Integer getConnectionPoolPerRoute() {
        return this.connectionPoolPerRoute;
    }

    public Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public void setProxy(BdkProxyConfig proxy) {
        this.proxy = proxy;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setConnectionPoolMax(Integer connectionPoolMax) {
        this.connectionPoolMax = connectionPoolMax;
    }

    public void setConnectionPoolPerRoute(Integer connectionPoolPerRoute) {
        this.connectionPoolPerRoute = connectionPoolPerRoute;
    }

    public void setDefaultHeaders(Map<String, String> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }
}

