/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.core.config.model;

import com.symphony.bdk.core.config.model.BdkConfig;
import com.symphony.bdk.core.config.model.BdkProxyConfig;
import com.symphony.bdk.core.config.model.BdkServerConfig;
import java.util.Map;
import java.util.function.Supplier;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public class BdkClientConfig
extends BdkServerConfig {
    private BdkConfig parentConfig;

    public BdkClientConfig() {
        this.scheme = null;
        this.host = null;
        this.port = null;
        this.context = null;
        this.connectionTimeout = null;
        this.readTimeout = null;
        this.connectionPoolMax = null;
        this.connectionPoolPerRoute = null;
        this.defaultHeaders = null;
    }

    public BdkClientConfig(BdkConfig parentConfig) {
        this();
        this.parentConfig = parentConfig;
    }

    public boolean overridesParentConfig() {
        return this.scheme != null || this.host != null || this.port != null || this.context != null;
    }

    @Override
    public String getScheme() {
        return this.thisOrParent(this.scheme, this.parentConfig::getScheme);
    }

    @Override
    public String getHost() {
        return this.thisOrParent(this.host, this.parentConfig::getHost);
    }

    @Override
    public Integer getPort() {
        return this.thisOrParent(this.port, this.parentConfig::getPort);
    }

    @Override
    public String getContext() {
        return this.thisOrParent(this.context, this.parentConfig::getContext);
    }

    @Override
    public Integer getConnectionTimeout() {
        return this.thisOrParent(this.connectionTimeout, this.parentConfig::getConnectionTimeout);
    }

    @Override
    public Integer getReadTimeout() {
        return this.thisOrParent(this.readTimeout, this.parentConfig::getReadTimeout);
    }

    @Override
    public Integer getConnectionPoolMax() {
        return this.thisOrParent(this.connectionPoolMax, this.parentConfig::getConnectionPoolMax);
    }

    @Override
    public Integer getConnectionPoolPerRoute() {
        return this.thisOrParent(this.connectionPoolPerRoute, this.parentConfig::getConnectionPoolPerRoute);
    }

    @Override
    public BdkProxyConfig getProxy() {
        return this.thisOrParent(this.proxy, this.parentConfig::getProxy);
    }

    @Override
    public Map<String, String> getDefaultHeaders() {
        return this.thisOrParent(this.defaultHeaders, this.parentConfig::getDefaultHeaders);
    }

    private <T> T thisOrParent(T thisValue, Supplier<T> parentValue) {
        return thisValue == null ? parentValue.get() : thisValue;
    }

    public BdkConfig getParentConfig() {
        return this.parentConfig;
    }

    public void setParentConfig(BdkConfig parentConfig) {
        this.parentConfig = parentConfig;
    }
}

