/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.core.config.model;

import com.symphony.bdk.core.config.exception.BdkConfigFormatException;
import com.symphony.bdk.core.config.model.BdkCertificateConfig;
import com.symphony.bdk.core.config.util.DeprecationLogger;
import org.apache.commons.lang3.ObjectUtils;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class BdkSslConfig {
    private static final Logger log = LoggerFactory.getLogger(BdkSslConfig.class);
    @Deprecated
    private String trustStorePath;
    @Deprecated
    private String trustStorePassword;
    private BdkCertificateConfig trustStore = new BdkCertificateConfig();

    public boolean isValid() {
        if (this.trustStore != null && this.trustStore.isConfigured()) {
            return this.trustStore.isValid() && !ObjectUtils.isNotEmpty((Object)this.trustStorePath);
        }
        return true;
    }

    public BdkCertificateConfig getCertificateConfig() {
        if (!this.isValid()) {
            throw new BdkConfigFormatException("Truststore configuration is not valid. This configuration should only be configured under \"trustStore\" field");
        }
        if (this.trustStore != null && this.trustStore.isConfigured()) {
            return this.trustStore;
        }
        BdkCertificateConfig sslTruststoreConfig = new BdkCertificateConfig(this.trustStorePath, this.trustStorePassword);
        if (sslTruststoreConfig.isConfigured()) {
            DeprecationLogger.logDeprecation("Truststore should be configured under \"trustStore\" field");
        }
        return sslTruststoreConfig;
    }

    @Deprecated
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Deprecated
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public BdkCertificateConfig getTrustStore() {
        return this.trustStore;
    }

    @Deprecated
    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    @Deprecated
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setTrustStore(BdkCertificateConfig trustStore) {
        this.trustStore = trustStore;
    }
}

