/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.core.config.model;

import com.symphony.bdk.core.config.model.BdkRetryConfig;
import com.symphony.bdk.core.config.util.DeprecationLogger;
import java.io.File;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public class BdkDatafeedConfig {
    private String version = "v2";
    private String idFilePath;
    private BdkRetryConfig retry = new BdkRetryConfig(-1);

    public void setVersion(String version) {
        if ("v1".equalsIgnoreCase(version)) {
            DeprecationLogger.logDeprecation("The datafeed 1 service will be fully replaced by the datafeed 2 service in the future. Please consider migrating over to datafeed 2. For more information on the timeline as well as on the benefits of datafeed 2, please reach out to your Technical Account Manager or to our developer documentation https://docs.developers.symphony.com/building-bots-on-symphony/datafeed)");
        }
        this.version = version;
    }

    public String getIdFilePath() {
        if (this.idFilePath == null || this.idFilePath.isEmpty()) {
            return "." + File.separator;
        }
        if (!this.idFilePath.endsWith(File.separator)) {
            return this.idFilePath + File.separator;
        }
        return this.idFilePath;
    }

    public String getVersion() {
        return this.version;
    }

    public BdkRetryConfig getRetry() {
        return this.retry;
    }

    public void setIdFilePath(String idFilePath) {
        this.idFilePath = idFilePath;
    }

    public void setRetry(BdkRetryConfig retry) {
        this.retry = retry;
    }
}

