/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.core.config.model;

import com.symphony.bdk.core.config.model.BdkCertificateConfig;
import com.symphony.bdk.core.config.model.BdkRsaKeyConfig;
import com.symphony.bdk.core.config.util.DeprecationLogger;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class BdkAuthenticationConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BdkAuthenticationConfig.class);
    @Deprecated
    protected String privateKeyPath;
    @Deprecated
    protected byte[] privateKeyContent;
    @Deprecated
    protected String certificatePath;
    @Deprecated
    protected byte[] certificateContent;
    @Deprecated
    protected String certificatePassword;
    protected BdkRsaKeyConfig privateKey = new BdkRsaKeyConfig();
    protected BdkCertificateConfig certificate = new BdkCertificateConfig();

    public boolean isRsaAuthenticationConfigured() {
        return this.privateKey != null && this.privateKey.isConfigured() || ObjectUtils.isNotEmpty((Object)this.privateKeyPath) || ObjectUtils.isNotEmpty((Object)this.privateKeyContent);
    }

    public boolean isRsaConfigurationValid() {
        if (this.privateKey != null && this.privateKey.isConfigured()) {
            if (ObjectUtils.isNotEmpty((Object)this.privateKeyPath) || ObjectUtils.isNotEmpty((Object)this.privateKeyContent)) {
                return false;
            }
            return this.privateKey.isValid();
        }
        return !ObjectUtils.isNotEmpty((Object)this.privateKeyPath) || !ObjectUtils.isNotEmpty((Object)this.privateKeyContent);
    }

    public boolean isCertificateAuthenticationConfigured() {
        return this.certificate != null && this.certificate.isConfigured() || (ObjectUtils.isNotEmpty((Object)this.certificatePath) || ObjectUtils.isNotEmpty((Object)this.certificateContent)) && this.certificatePassword != null;
    }

    public boolean isCertificateConfigurationValid() {
        if (this.certificate != null && this.certificate.isConfigured()) {
            if (ObjectUtils.isNotEmpty((Object)this.certificatePath) || ObjectUtils.isNotEmpty((Object)this.certificateContent)) {
                return false;
            }
            return this.certificate.isValid();
        }
        return !ObjectUtils.isNotEmpty((Object)this.certificatePath) || !ObjectUtils.isNotEmpty((Object)this.certificateContent);
    }

    public boolean isBothCertificateAndRsaConfigured() {
        return this.isRsaAuthenticationConfigured() && this.isCertificateAuthenticationConfigured();
    }

    public BdkCertificateConfig getCertificateConfig() {
        if (this.certificate != null && this.certificate.isConfigured()) {
            return this.certificate;
        }
        DeprecationLogger.logDeprecation("Certificate should be configured under \"certificate\" field");
        return new BdkCertificateConfig(this.certificatePath, this.certificateContent, this.certificatePassword);
    }

    @Deprecated
    @Generated
    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    @Deprecated
    @Generated
    public byte[] getPrivateKeyContent() {
        return this.privateKeyContent;
    }

    @Deprecated
    @Generated
    public String getCertificatePath() {
        return this.certificatePath;
    }

    @Deprecated
    @Generated
    public byte[] getCertificateContent() {
        return this.certificateContent;
    }

    @Deprecated
    @Generated
    public String getCertificatePassword() {
        return this.certificatePassword;
    }

    @Generated
    public BdkRsaKeyConfig getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public BdkCertificateConfig getCertificate() {
        return this.certificate;
    }

    @Deprecated
    @Generated
    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    @Deprecated
    @Generated
    public void setPrivateKeyContent(byte[] privateKeyContent) {
        this.privateKeyContent = privateKeyContent;
    }

    @Deprecated
    @Generated
    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    @Deprecated
    @Generated
    public void setCertificateContent(byte[] certificateContent) {
        this.certificateContent = certificateContent;
    }

    @Deprecated
    @Generated
    public void setCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
    }

    @Generated
    public void setPrivateKey(BdkRsaKeyConfig privateKey) {
        this.privateKey = privateKey;
    }

    @Generated
    public void setCertificate(BdkCertificateConfig certificate) {
        this.certificate = certificate;
    }
}

