/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.core.config.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.STABLE)
public class BdkCertificateConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BdkCertificateConfig.class);
    private String path;
    private byte[] content;
    private String password;

    public BdkCertificateConfig() {
    }

    public BdkCertificateConfig(String path, String password) {
        this(path, null, password);
    }

    public BdkCertificateConfig(String path, byte[] content, String password) {
        this.path = path;
        this.content = content;
        this.password = password;
    }

    public boolean isConfigured() {
        if (this.password == null && (ObjectUtils.isNotEmpty((Object)this.path) || ObjectUtils.isNotEmpty((Object)this.content))) {
            log.error("Field \"password\" is missing for certificate authentication.");
            return false;
        }
        if (ObjectUtils.isNotEmpty((Object)this.path) && ObjectUtils.isNotEmpty((Object)this.content)) {
            log.error("Found both \"content\" and \"path\" field while configuring certificate authentication, only one is allowed");
        }
        if (this.password != null && ObjectUtils.isEmpty((Object)this.path) && ObjectUtils.isEmpty((Object)this.content)) {
            log.error("At least one between \"content\" and \"path\" field should be configured for certificate authentication");
            return false;
        }
        return (ObjectUtils.isNotEmpty((Object)this.path) || ObjectUtils.isNotEmpty((Object)this.content)) && this.password != null;
    }

    public boolean isValid() {
        return !ObjectUtils.isNotEmpty((Object)this.path) || !ObjectUtils.isNotEmpty((Object)this.content);
    }

    public byte[] getCertificateBytes() {
        if (ObjectUtils.isNotEmpty((Object)this.content)) {
            return this.content;
        }
        return this.getBytesFromFile(this.path);
    }

    private byte[] getBytesFromFile(String filePath) {
        try {
            if (filePath.startsWith("classpath:")) {
                URL resource = this.getClass().getResource(filePath.replace("classpath:", ""));
                if (resource != null) {
                    return Files.readAllBytes(Paths.get(resource.toURI()));
                }
                throw new FileNotFoundException("File not found in classpath: " + filePath);
            }
            return Files.readAllBytes(new File(filePath).toPath());
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalArgumentException("Could not read file " + filePath, e);
        }
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public byte[] getContent() {
        return this.content;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setContent(byte[] content) {
        this.content = content;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }
}

