/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.core.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.symphony.bdk.core.config.exception.BdkConfigException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.INTERNAL)
class BdkConfigParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BdkConfigParser.class);
    private static final ObjectMapper JSON_MAPPER = new JsonMapper();
    private static final ObjectMapper YAML_MAPPER = new YAMLMapper();
    private final StringSubstitutor envVarStringSubstitutor = new StringSubstitutor(StringLookupFactory.INSTANCE.environmentVariableStringLookup());

    public JsonNode parse(InputStream inputStream) throws BdkConfigException {
        JsonNode jsonNode = this.parseJsonNode(inputStream);
        this.interpolateProperties(jsonNode);
        return jsonNode;
    }

    public JsonNode parseJsonNode(InputStream inputStream) throws BdkConfigException {
        String content = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        try {
            return JSON_MAPPER.readTree(content);
        }
        catch (IOException e) {
            log.debug("Config file is not in JSON format, checking for YAML format.");
            try {
                JsonNode jsonNode = YAML_MAPPER.readTree(content);
                if (jsonNode.isContainerNode()) {
                    log.debug("Config file found in YAML format.");
                    return jsonNode;
                }
            }
            catch (IOException e2) {
                log.debug("Config file is not in YAML format.");
            }
            throw new BdkConfigException("Given InputStream is not valid. Only YAML or JSON are allowed.");
        }
    }

    public void interpolateProperties(JsonNode jsonNode) {
        if (jsonNode.isArray()) {
            for (JsonNode arrayItem : jsonNode) {
                this.interpolateProperties(arrayItem);
            }
        } else if (jsonNode.isObject()) {
            this.interpolatePropertiesInObject((ObjectNode)jsonNode);
        }
    }

    private void interpolatePropertiesInObject(ObjectNode objectNode) {
        Iterator fieldNames = objectNode.fieldNames();
        while (fieldNames.hasNext()) {
            this.interpolatePropertyInField(objectNode, (String)fieldNames.next());
        }
    }

    private void interpolatePropertyInField(ObjectNode objectNode, String field) {
        JsonNode node = objectNode.get(field);
        if (node.isTextual()) {
            String interpolatedFieldValue = this.envVarStringSubstitutor.replace(StringSubstitutor.replaceSystemProperties((Object)node.asText()));
            objectNode.set(field, (JsonNode)new TextNode(interpolatedFieldValue));
        } else if (node.isObject() || node.isArray()) {
            this.interpolateProperties(node);
        }
    }

    static {
        JSON_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        YAML_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

