/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.core.config.model;

import lombok.Generated;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public class BdkRetryConfig {
    public static final int INFINITE_MAX_ATTEMPTS = -1;
    public static final int DEFAULT_MAX_ATTEMPTS = 10;
    public static final long DEFAULT_INITIAL_INTERVAL_MILLIS = 500L;
    public static final double DEFAULT_MULTIPLIER = 2.0;
    public static final long DEFAULT_MAX_INTERVAL_MILLIS = 300000L;
    private Integer maxAttempts;
    private Long initialIntervalMillis;
    private Double multiplier;
    private Long maxIntervalMillis;

    public BdkRetryConfig(Integer maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public Integer getMaxAttempts() {
        if (this.maxAttempts == null) {
            return 10;
        }
        if (this.maxAttempts < 0) {
            return Integer.MAX_VALUE;
        }
        return this.maxAttempts;
    }

    public Long getInitialIntervalMillis() {
        if (this.initialIntervalMillis == null) {
            return 500L;
        }
        return this.initialIntervalMillis;
    }

    public Double getMultiplier() {
        if (this.multiplier == null || this.multiplier < 1.0) {
            return 2.0;
        }
        return this.multiplier;
    }

    public Long getMaxIntervalMillis() {
        if (this.maxIntervalMillis == null) {
            return 300000L;
        }
        return this.maxIntervalMillis;
    }

    @Generated
    public void setMaxAttempts(Integer maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    @Generated
    public void setInitialIntervalMillis(Long initialIntervalMillis) {
        this.initialIntervalMillis = initialIntervalMillis;
    }

    @Generated
    public void setMultiplier(Double multiplier) {
        this.multiplier = multiplier;
    }

    @Generated
    public void setMaxIntervalMillis(Long maxIntervalMillis) {
        this.maxIntervalMillis = maxIntervalMillis;
    }

    @Generated
    public BdkRetryConfig() {
    }
}

