/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.core.config.model;

import com.symphony.bdk.core.config.model.BdkProxyConfig;
import java.util.Map;
import lombok.Generated;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public class BdkServerConfig {
    protected static final String DEFAULT_SCHEME = "https";
    protected static final int DEFAULT_HTTPS_PORT = 443;
    protected BdkProxyConfig proxy;
    protected String scheme = "https";
    protected String host;
    protected Integer port = 443;
    protected String context = "";
    protected Integer connectionTimeout;
    protected Integer readTimeout;
    protected Integer connectionPoolMax;
    protected Integer connectionPoolPerRoute;
    protected Map<String, String> defaultHeaders;

    public String getBasePath() {
        return this.getScheme() + "://" + this.getHost() + this.getPortAsString() + this.getFormattedContext();
    }

    public String getFormattedContext() {
        String localContext = this.getContext();
        if (localContext == null) {
            return "";
        }
        if (!localContext.equals("") && localContext.charAt(0) != '/') {
            return "/" + localContext;
        }
        if (!localContext.equals("") && localContext.endsWith("/")) {
            return localContext.substring(0, localContext.length() - 1);
        }
        return localContext;
    }

    private String getPortAsString() {
        return this.getPort() != null ? ":" + this.getPort() : "";
    }

    @Generated
    public BdkProxyConfig getProxy() {
        return this.proxy;
    }

    @Generated
    public String getScheme() {
        return this.scheme;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Generated
    public Integer getConnectionPoolMax() {
        return this.connectionPoolMax;
    }

    @Generated
    public Integer getConnectionPoolPerRoute() {
        return this.connectionPoolPerRoute;
    }

    @Generated
    public Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    @Generated
    public void setProxy(BdkProxyConfig proxy) {
        this.proxy = proxy;
    }

    @Generated
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setContext(String context) {
        this.context = context;
    }

    @Generated
    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Generated
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Generated
    public void setConnectionPoolMax(Integer connectionPoolMax) {
        this.connectionPoolMax = connectionPoolMax;
    }

    @Generated
    public void setConnectionPoolPerRoute(Integer connectionPoolPerRoute) {
        this.connectionPoolPerRoute = connectionPoolPerRoute;
    }

    @Generated
    public void setDefaultHeaders(Map<String, String> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }
}

