/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.http.api;

import com.symphony.bdk.http.api.ApiClient;
import com.symphony.bdk.http.api.ApiClientBuilder;
import com.symphony.bdk.http.api.ApiClientBuilderProvider;
import com.symphony.bdk.http.api.ApiException;
import com.symphony.bdk.http.api.ApiResponse;
import com.symphony.bdk.http.api.Pair;
import com.symphony.bdk.http.api.util.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpClient {
    private final ApiClient apiClient;
    private final RequestConfig requestConfig;

    private HttpClient(ApiClient apiClient, RequestConfig requestConfig) {
        this.apiClient = apiClient;
        this.requestConfig = requestConfig;
    }

    public <T> T method(String method, TypeReference<T> type) throws ApiException {
        ApiResponse<T> response = this.apiClient.invokeAPI(this.requestConfig.getPath(), method, this.requestConfig.getQueryParams(), this.requestConfig.getBody(), this.requestConfig.getHeaders(), this.requestConfig.getCookies(), this.requestConfig.getFormParams(), this.requestConfig.getAccept(), this.requestConfig.getContentType() == null ? "application/json" : this.requestConfig.getContentType(), new String[0], type);
        return response != null ? (T)response.getData() : null;
    }

    public <T> T get(TypeReference<T> type) throws ApiException {
        return this.method("GET", type);
    }

    public <T> T post(TypeReference<T> type) throws ApiException {
        return this.method("POST", type);
    }

    public <T> T put(TypeReference<T> type) throws ApiException {
        return this.method("PUT", type);
    }

    public <T> T patch(TypeReference<T> type) throws ApiException {
        return this.method("PATCH", type);
    }

    public <T> T delete(TypeReference<T> type) throws ApiException {
        return this.method("DELETE", type);
    }

    public static Builder builder(ApiClientBuilderProvider provider) {
        return new Builder(provider);
    }

    public HttpClient path(String path) {
        return new HttpClient(this.apiClient, this.requestConfig.withPath(path));
    }

    public HttpClient header(String key, String value) {
        return new HttpClient(this.apiClient, this.requestConfig.withHeaders(this.requestConfig.appendHeader(key, value)));
    }

    public HttpClient cookie(String key, String value) {
        return new HttpClient(this.apiClient, this.requestConfig.withCookies(this.requestConfig.appendCookie(key, value)));
    }

    public HttpClient queryParam(String key, String value) {
        return new HttpClient(this.apiClient, this.requestConfig.withQueryParams(this.requestConfig.appendQueryParam(key, value)));
    }

    public HttpClient formParam(String key, Object value) {
        return new HttpClient(this.apiClient, this.requestConfig.withFormParams(this.requestConfig.appendFormParam(key, value)));
    }

    public HttpClient body(Object body) {
        return new HttpClient(this.apiClient, this.requestConfig.withBody(body));
    }

    public HttpClient accept(String accept) {
        return new HttpClient(this.apiClient, this.requestConfig.withAccept(accept));
    }

    public HttpClient contentType(String contentType) {
        return new HttpClient(this.apiClient, this.requestConfig.withContentType(contentType));
    }

    private static class RequestConfig {
        private Map<String, String> headers;
        private Map<String, String> cookies;
        private Map<String, List<Object>> formParams;
        private List<Pair> queryParams;
        private String path;
        private Object body;
        private String accept;
        private String contentType;

        public Map<String, Object> getFormParams() {
            return this.formParams == null ? Collections.emptyMap() : new HashMap<String, List<Object>>(this.formParams);
        }

        public Map<String, String> appendHeader(String key, String value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(key, value);
            return this.headers;
        }

        public Map<String, String> appendCookie(String key, String value) {
            if (this.cookies == null) {
                this.cookies = new HashMap<String, String>();
            }
            this.cookies.put(key, value);
            return this.cookies;
        }

        public List<Pair> appendQueryParam(String key, String value) {
            if (this.queryParams == null) {
                this.queryParams = new ArrayList<Pair>();
            }
            this.queryParams.add(new Pair(key, value));
            return this.queryParams;
        }

        public Map<String, List<Object>> appendFormParam(String key, Object value) {
            if (this.formParams == null) {
                this.formParams = new HashMap<String, List<Object>>();
            }
            if (!this.formParams.containsKey(key)) {
                this.formParams.put(key, new ArrayList());
            }
            this.formParams.get(key).add(value);
            return this.formParams;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Map<String, String> getCookies() {
            return this.cookies;
        }

        public List<Pair> getQueryParams() {
            return this.queryParams;
        }

        public String getPath() {
            return this.path;
        }

        public Object getBody() {
            return this.body;
        }

        public String getAccept() {
            return this.accept;
        }

        public String getContentType() {
            return this.contentType;
        }

        public RequestConfig() {
        }

        public RequestConfig(Map<String, String> headers, Map<String, String> cookies, Map<String, List<Object>> formParams, List<Pair> queryParams, String path, Object body, String accept, String contentType) {
            this.headers = headers;
            this.cookies = cookies;
            this.formParams = formParams;
            this.queryParams = queryParams;
            this.path = path;
            this.body = body;
            this.accept = accept;
            this.contentType = contentType;
        }

        protected RequestConfig withHeaders(Map<String, String> headers) {
            return this.headers == headers ? this : new RequestConfig(headers, this.cookies, this.formParams, this.queryParams, this.path, this.body, this.accept, this.contentType);
        }

        protected RequestConfig withCookies(Map<String, String> cookies) {
            return this.cookies == cookies ? this : new RequestConfig(this.headers, cookies, this.formParams, this.queryParams, this.path, this.body, this.accept, this.contentType);
        }

        protected RequestConfig withFormParams(Map<String, List<Object>> formParams) {
            return this.formParams == formParams ? this : new RequestConfig(this.headers, this.cookies, formParams, this.queryParams, this.path, this.body, this.accept, this.contentType);
        }

        protected RequestConfig withQueryParams(List<Pair> queryParams) {
            return this.queryParams == queryParams ? this : new RequestConfig(this.headers, this.cookies, this.formParams, queryParams, this.path, this.body, this.accept, this.contentType);
        }

        protected RequestConfig withPath(String path) {
            return this.path == path ? this : new RequestConfig(this.headers, this.cookies, this.formParams, this.queryParams, path, this.body, this.accept, this.contentType);
        }

        protected RequestConfig withBody(Object body) {
            return this.body == body ? this : new RequestConfig(this.headers, this.cookies, this.formParams, this.queryParams, this.path, body, this.accept, this.contentType);
        }

        protected RequestConfig withAccept(String accept) {
            return this.accept == accept ? this : new RequestConfig(this.headers, this.cookies, this.formParams, this.queryParams, this.path, this.body, accept, this.contentType);
        }

        protected RequestConfig withContentType(String contentType) {
            return this.contentType == contentType ? this : new RequestConfig(this.headers, this.cookies, this.formParams, this.queryParams, this.path, this.body, this.accept, contentType);
        }
    }

    public static class Builder {
        private final ApiClientBuilderProvider provider;
        private String basePath = "";
        private byte[] keyStore = null;
        private String keyStorePassword = "";
        private byte[] trustStore = null;
        private String trustStorePassword = "";
        private String proxyHost = null;
        private int proxyPort = -1;
        private String proxyUser = null;
        private String proxyPassword = null;
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, String> cookies = new HashMap<String, String>();

        public Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder header(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder cookie(String key, String value) {
            this.cookies.put(key, value);
            return this;
        }

        public Builder keyStore(byte[] keyStore, String keyStorePassword) {
            this.keyStore = keyStore;
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder trustStore(byte[] trustStore, String trustStorePassword) {
            this.trustStore = trustStore;
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public Builder proxy(String proxyHost, int proxyPort) {
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder proxyCredentials(String proxyUser, String proxyPassword) {
            this.proxyUser = proxyUser;
            this.proxyPassword = proxyPassword;
            return this;
        }

        public HttpClient build() {
            ApiClientBuilder builder = this.provider.newInstance();
            if (this.basePath != null) {
                builder.withBasePath(this.basePath);
            }
            if (this.keyStore != null) {
                builder.withKeyStore(this.keyStore, this.keyStorePassword);
            }
            if (this.trustStore != null) {
                builder.withTrustStore(this.trustStore, this.trustStorePassword);
            }
            if (this.proxyHost != null) {
                builder.withProxy(this.proxyHost, this.proxyPort);
            }
            if (this.proxyUser != null && this.proxyPassword != null) {
                builder.withProxyCredentials(this.proxyUser, this.proxyPassword);
            }
            return new HttpClient(builder.build(), new RequestConfig().withHeaders(this.headers).withCookies(this.cookies));
        }

        public Builder(ApiClientBuilderProvider provider) {
            this.provider = provider;
        }
    }
}

