/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.http.api.tracing;

import java.util.Map;
import org.apiguardian.api.API;
import org.slf4j.MDC;

@API(status=API.Status.STABLE)
public final class MDCUtils {
    private MDCUtils() {
    }

    public static Runnable wrap(Runnable runnable) {
        return new MdcRunnable(runnable);
    }

    private static Map<String, String> beforeCallMDCSetup(Map<String, String> parentContext) {
        Map childContext = MDC.getCopyOfContextMap();
        if (parentContext != null) {
            if (childContext != null) {
                parentContext.putAll(childContext);
            }
            MDC.setContextMap(parentContext);
        }
        return childContext;
    }

    private static void afterCallMDCCleanUp(Map<String, String> childContext) {
        MDC.clear();
        if (childContext != null) {
            MDC.setContextMap(childContext);
        }
    }

    private static class MdcRunnable
    implements Runnable {
        private final Map<String, String> parentContext = MDC.getCopyOfContextMap();
        private final Runnable runnable;

        @Override
        public void run() {
            Map childContext = MDCUtils.beforeCallMDCSetup(this.parentContext);
            try {
                this.runnable.run();
            }
            finally {
                MDCUtils.afterCallMDCCleanUp(childContext);
            }
        }

        public MdcRunnable(Runnable runnable) {
            this.runnable = runnable;
        }
    }
}

