/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.http.api;

import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public class ApiException
extends Exception {
    private int code = 0;
    private Map<String, List<String>> responseHeaders = null;
    private String responseBody = null;

    public ApiException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public ApiException(int code, String message) {
        super(message);
        this.code = code;
    }

    public ApiException(int code, String message, Map<String, List<String>> responseHeaders, String responseBody) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public boolean isUnauthorized() {
        return this.code == 401;
    }

    public boolean isClientError() {
        return this.code == 400;
    }

    public boolean isServerError() {
        return this.code >= 500;
    }

    public boolean isTooManyRequestsError() {
        return this.code == 429;
    }

    public int getCode() {
        return this.code;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }
}

