/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.http.api.tracing;

import java.security.SecureRandom;
import org.apiguardian.api.API;
import org.slf4j.MDC;

@API(status=API.Status.STABLE)
public final class DistributedTracingContext {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final int TRACE_ID_SIZE = 6;
    private static final char TRACE_ID_SEPARATOR = ':';
    public static final String TRACE_ID = "X-Trace-Id";

    private DistributedTracingContext() {
    }

    public static void setTraceId() {
        MDC.put((String)TRACE_ID, (String)DistributedTracingContext.randomAlphanumeric(6));
    }

    public static void setTraceId(String traceId) {
        MDC.put((String)TRACE_ID, (String)traceId);
    }

    public static void setBaseTraceId(String baseTraceId) {
        MDC.put((String)TRACE_ID, (String)(baseTraceId + ":" + DistributedTracingContext.randomAlphanumeric(6)));
    }

    public static String getTraceId() {
        return MDC.get((String)TRACE_ID) != null ? MDC.get((String)TRACE_ID) : "";
    }

    public static boolean hasTraceId() {
        return !DistributedTracingContext.getTraceId().isEmpty();
    }

    public static void clear() {
        MDC.remove((String)TRACE_ID);
    }

    public static void doWithTraceId(String traceId, Runnable runnable) {
        String backup = DistributedTracingContext.getTraceId();
        DistributedTracingContext.setTraceId(traceId);
        try {
            runnable.run();
        }
        finally {
            DistributedTracingContext.clear();
            DistributedTracingContext.setTraceId(backup);
        }
    }

    private static String randomAlphanumeric(int size) {
        int leftLimit = 48;
        int rightLimit = 122;
        return RANDOM.ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(size).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }
}

