/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.http.api.util;

import com.symphony.bdk.http.api.ApiClientBodyPart;
import java.io.File;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.INTERNAL)
public final class ApiUtils {
    private static final Logger log = LoggerFactory.getLogger(ApiUtils.class);

    public static String getUserAgent() {
        return "Symphony-BDK-Java/" + ApiUtils.getBdkVersion() + " Java/" + System.getProperty("java.version");
    }

    public static void logTrustStore(KeyStore trustStore) throws KeyStoreException {
        if (log.isDebugEnabled()) {
            for (String alias : Collections.list(trustStore.aliases())) {
                log.debug("Loading {} from truststore", (Object)alias);
            }
        }
    }

    public static void addDefaultRootCaCertificates(KeyStore trustStore) throws GeneralSecurityException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            for (X509Certificate acceptedIssuer : ((X509TrustManager)trustManager).getAcceptedIssuers()) {
                trustStore.setCertificateEntry(acceptedIssuer.getSubjectDN().getName(), acceptedIssuer);
            }
        }
    }

    public static boolean isCollectionOfFiles(Object paramValue) {
        return ApiUtils.isCollectionOf(paramValue, File.class);
    }

    public static boolean isCollectionOfApiClientBodyPart(Object paramValue) {
        return ApiUtils.isCollectionOf(paramValue, ApiClientBodyPart.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isCollectionOf(Object paramValue, Class clazz) {
        if (!(paramValue instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)paramValue;
        if (collection.isEmpty()) return false;
        if (!collection.stream().allMatch(clazz::isInstance)) return false;
        return true;
    }

    private static String getBdkVersion() {
        String jarVersion = ApiUtils.class.getPackage().getImplementationVersion();
        String bdkVersion = jarVersion == null ? "2.0" : jarVersion;
        int dash = bdkVersion.indexOf("-");
        if (dash != -1) {
            bdkVersion = bdkVersion.substring(0, dash);
        }
        return bdkVersion;
    }

    private ApiUtils() {
    }
}

