/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.http.jersey2;

import com.symphony.bdk.http.api.ApiClient;
import com.symphony.bdk.http.api.ApiClientBodyPart;
import com.symphony.bdk.http.api.ApiException;
import com.symphony.bdk.http.api.ApiResponse;
import com.symphony.bdk.http.api.Pair;
import com.symphony.bdk.http.api.tracing.DistributedTracingContext;
import com.symphony.bdk.http.api.util.TypeReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apiguardian.api.API;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartMediaTypes;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;

@API(status=API.Status.STABLE)
public class ApiClientJersey2
implements ApiClient {
    protected Client httpClient;
    protected String basePath;
    protected Map<String, String> defaultHeaderMap;
    protected String tempFolderPath;

    public ApiClientJersey2(Client httpClient, String basePath, Map<String, String> defaultHeaders, String temporaryFolderPath) {
        this.httpClient = httpClient;
        this.basePath = basePath;
        this.defaultHeaderMap = new HashMap<String, String>(defaultHeaders);
        this.tempFolderPath = temporaryFolderPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> ApiResponse<T> invokeAPI(String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, String> cookieParams, Map<String, Object> formParams, String accept, String contentType, String[] authNames, TypeReference<T> returnType) throws ApiException {
        String value;
        WebTarget target = this.httpClient.target(this.basePath + path);
        if (queryParams != null) {
            for (Pair queryParam : queryParams) {
                if (queryParam.getValue() == null) continue;
                target = target.queryParam(queryParam.getName(), new Object[]{this.escapeString(queryParam.getValue())});
            }
        }
        Invocation.Builder invocationBuilder = target.request().accept(new String[]{accept});
        boolean clearTraceId = false;
        if (!DistributedTracingContext.hasTraceId()) {
            DistributedTracingContext.setTraceId();
            clearTraceId = true;
        }
        invocationBuilder = invocationBuilder.header("X-Trace-Id", (Object)DistributedTracingContext.getTraceId());
        if (headerParams != null) {
            for (Map.Entry<String, String> entry : headerParams.entrySet()) {
                value = entry.getValue();
                if (value == null) continue;
                invocationBuilder = invocationBuilder.header(entry.getKey(), (Object)value);
            }
        }
        if (cookieParams != null) {
            for (Map.Entry<String, String> entry : cookieParams.entrySet()) {
                value = entry.getValue();
                if (value == null) continue;
                invocationBuilder = invocationBuilder.cookie(entry.getKey(), value);
            }
        }
        for (Map.Entry<String, String> entry : this.defaultHeaderMap.entrySet()) {
            String value2;
            String key = entry.getKey();
            if (headerParams.containsKey(key) || (value2 = entry.getValue()) == null) continue;
            invocationBuilder = invocationBuilder.header(key, (Object)value2);
        }
        if (contentType.startsWith("multipart/form-data")) {
            invocationBuilder.header("MIME-Version", (Object)"1.0");
        }
        Entity<?> entity = body == null && formParams == null ? Entity.json((Object)"") : this.serialize(body, formParams, contentType);
        try (Response response = this.getResponse(invocationBuilder, method, entity);){
            int statusCode = response.getStatusInfo().getStatusCode();
            Map<String, List<String>> responseHeaders = this.buildResponseHeaders(response);
            GenericType genericReturnType = null;
            if (returnType != null) {
                genericReturnType = new GenericType(returnType.getType());
            }
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                ApiResponse apiResponse = new ApiResponse(statusCode, responseHeaders);
                return apiResponse;
            }
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                if (genericReturnType == null) {
                    ApiResponse apiResponse = new ApiResponse(statusCode, responseHeaders);
                    return apiResponse;
                }
                ApiResponse apiResponse = new ApiResponse(statusCode, responseHeaders, this.deserialize(response, genericReturnType));
                return apiResponse;
            }
            String message = "error";
            String respBody = null;
            if (!response.hasEntity()) throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
            try {
                message = respBody = String.valueOf(response.readEntity(String.class));
                throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw new ApiException(response.getStatus(), message, this.buildResponseHeaders(response), respBody);
        }
        finally {
            if (clearTraceId) {
                DistributedTracingContext.clear();
            }
        }
    }

    private Response getResponse(Invocation.Builder invocationBuilder, String method, Entity<?> entity) throws ApiException {
        try {
            switch (method) {
                case "GET": {
                    return invocationBuilder.get();
                }
                case "POST": {
                    return invocationBuilder.post(entity);
                }
                case "PUT": {
                    return invocationBuilder.put(entity);
                }
                case "DELETE": {
                    return invocationBuilder.method("DELETE", entity);
                }
                case "PATCH": {
                    return invocationBuilder.method("PATCH", entity);
                }
                case "HEAD": {
                    return invocationBuilder.head();
                }
                case "OPTIONS": {
                    return invocationBuilder.options();
                }
                case "TRACE": {
                    return invocationBuilder.trace();
                }
            }
            throw new ApiException(500, "unknown method type " + method);
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof ConnectTimeoutException) {
                throw new ProcessingException((Throwable)new SocketTimeoutException(e.getCause().getMessage()));
            }
            if (e.getCause() instanceof NoHttpResponseException) {
                throw new ProcessingException((Throwable)new SocketException(e.getCause().getMessage()));
            }
            throw e;
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(o);
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        String format;
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        Collection valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = format = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if ("multi".equals(format)) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        switch (format) {
            case "csv": {
                delimiter = ",";
                break;
            }
            case "ssv": {
                delimiter = " ";
                break;
            }
            case "tsv": {
                delimiter = "\t";
                break;
            }
            case "pipes": {
                delimiter = "|";
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return String.join((CharSequence)",", accepts);
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    protected boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    protected Entity<?> serialize(Object obj, Map<String, Object> formParams, String contentType) {
        if (contentType.startsWith("multipart/form-data")) {
            return this.serializeMultiPartFormDataEntity(formParams);
        }
        if (contentType.startsWith("application/x-www-form-urlencoded")) {
            Form form = new Form();
            formParams.forEach((key, value) -> form.param(key, this.parameterToString(value)));
            return Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        }
        return Entity.entity((Object)obj, (String)contentType);
    }

    private Entity<?> serializeMultiPartFormDataEntity(Map<String, Object> formParams) {
        FormDataMultiPart multiPart = new FormDataMultiPart();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            if (param.getValue() instanceof File) {
                ApiClientBodyPart[] file = (ApiClientBodyPart[])param.getValue();
                FormDataContentDisposition contentDisposition = ((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)param.getKey()).fileName(file.getName())).size(file.length())).build();
                FormDataBodyPart streamPart = new FormDataBodyPart(contentDisposition, (Object)file, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                multiPart = (FormDataMultiPart)multiPart.bodyPart((BodyPart)streamPart);
                continue;
            }
            if (param.getValue() instanceof ApiClientBodyPart[]) {
                for (ApiClientBodyPart attachment : (ApiClientBodyPart[])param.getValue()) {
                    StreamDataBodyPart streamPart = new StreamDataBodyPart(param.getKey(), attachment.getContent(), attachment.getFilename());
                    multiPart = (FormDataMultiPart)multiPart.bodyPart((BodyPart)streamPart);
                }
                continue;
            }
            if (param.getValue() instanceof ApiClientBodyPart) {
                ApiClientBodyPart part = (ApiClientBodyPart)param.getValue();
                StreamDataBodyPart streamPart = new StreamDataBodyPart(param.getKey(), part.getContent(), part.getFilename());
                multiPart = (FormDataMultiPart)multiPart.bodyPart((BodyPart)streamPart);
                continue;
            }
            multiPart = multiPart.field(param.getKey(), this.parameterToString(param.getValue()));
        }
        return Entity.entity((Object)multiPart, (MediaType)MultiPartMediaTypes.createFormData());
    }

    protected <T> T deserialize(Response response, GenericType<T> returnType) throws ApiException {
        if (response == null || returnType == null) {
            return null;
        }
        if ("byte[]".equals(returnType.toString())) {
            return (T)response.readEntity(byte[].class);
        }
        if (returnType.getRawType() == File.class) {
            return (T)this.downloadFileFromResponse(response);
        }
        return (T)response.readEntity(returnType);
    }

    protected File downloadFileFromResponse(Response response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            Files.copy((InputStream)response.readEntity(InputStream.class), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException e) {
            throw new ApiException("Unable to download file from response", (Throwable)e);
        }
    }

    protected File prepareDownloadFile(Response response) throws IOException {
        String prefix;
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        String contentDisposition = (String)response.getHeaders().getFirst((Object)"Content-Disposition");
        if (contentDisposition != null && !"".equals(contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = matcher.group(1);
        }
        String suffix = null;
        if (filename == null) {
            prefix = "download-";
            suffix = "";
        } else {
            int pos = filename.lastIndexOf(46);
            if (pos == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, pos) + "-";
                suffix = filename.substring(pos);
            }
            if (prefix.length() < 3) {
                prefix = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return File.createTempFile(prefix, suffix);
        }
        return File.createTempFile(prefix, suffix, new File(this.tempFolderPath));
    }

    protected Map<String, List<String>> buildResponseHeaders(Response response) {
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            List values = (List)entry.getValue();
            ArrayList<String> headers = new ArrayList<String>();
            for (Object o : values) {
                headers.add(String.valueOf(o));
            }
            responseHeaders.put((String)entry.getKey(), (List<String>)headers);
        }
        return responseHeaders;
    }
}

