/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.http.jersey2;

import com.symphony.bdk.http.api.ApiClient;
import com.symphony.bdk.http.api.ApiClientBuilder;
import com.symphony.bdk.http.api.auth.Authentication;
import com.symphony.bdk.http.api.util.ApiUtils;
import com.symphony.bdk.http.jersey2.ApiClientJersey2;
import com.symphony.bdk.http.jersey2.ApiClientJersey2RequestLogFilter;
import com.symphony.bdk.http.jersey2.JSON;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apiguardian.api.API;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

@API(status=API.Status.STABLE)
public class ApiClientBuilderJersey2
implements ApiClientBuilder {
    private static final String TRUSTSTORE_FORMAT = "JKS";
    protected String basePath = "https://acme.symphony.com";
    protected byte[] keyStoreBytes = null;
    protected String keyStorePassword = null;
    protected byte[] trustStoreBytes = null;
    protected String trustStorePassword = null;
    protected Map<String, String> defaultHeaders = new HashMap<String, String>();
    protected int connectionTimeout = 15000;
    protected int readTimeout = 60000;
    protected int connectionPoolMax = 20;
    protected int connectionPoolPerRoute = 20;
    protected String temporaryFolderPath = null;
    protected String proxyUrl = null;
    protected String proxyUser = null;
    protected String proxyPassword = null;
    protected Map<String, Authentication> authentications = new HashMap<String, Authentication>();

    public ApiClientBuilderJersey2() {
        this.withUserAgent(ApiUtils.getUserAgent());
    }

    public ApiClient build() {
        Logger.getLogger("org.glassfish.jersey.client").setLevel(Level.SEVERE);
        SSLContext sslContext = this.createSSLContext();
        Client httpClient = ClientBuilder.newBuilder().sslContext(sslContext).withConfig((Configuration)this.createClientConfig(sslContext)).build();
        httpClient.property("jersey.config.client.connectTimeout", (Object)this.connectionTimeout);
        httpClient.property("jersey.config.client.readTimeout", (Object)this.readTimeout);
        ApiClientJersey2 apiClient = new ApiClientJersey2(httpClient, this.basePath, this.defaultHeaders, this.temporaryFolderPath);
        this.authentications.forEach(apiClient.getAuthentications()::put);
        return apiClient;
    }

    public ApiClientBuilder withBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public ApiClientBuilder withUserAgent(String userAgent) {
        this.withDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClientBuilder withKeyStore(byte[] keyStoreBytes, String keyStorePassword) {
        this.keyStoreBytes = keyStoreBytes;
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public ApiClientBuilder withTrustStore(byte[] trustStoreBytes, String trustStorePassword) {
        this.trustStoreBytes = trustStoreBytes;
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public ApiClientBuilder withDefaultHeader(String key, String value) {
        this.defaultHeaders.put(key, value);
        return this;
    }

    public ApiClientBuilder withTemporaryFolderPath(String temporaryFolderPath) {
        this.temporaryFolderPath = temporaryFolderPath;
        return this;
    }

    public ApiClientBuilder withConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout == null ? 15000 : connectionTimeout;
        return this;
    }

    public ApiClientBuilder withReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout == null ? 60000 : readTimeout;
        return this;
    }

    public ApiClientBuilder withConnectionPoolMax(Integer connectionPoolMax) {
        this.connectionPoolMax = connectionPoolMax == null ? 20 : connectionPoolMax;
        return this;
    }

    public ApiClientBuilder withConnectionPoolPerRoute(Integer connectionPoolPerRoute) {
        this.connectionPoolPerRoute = connectionPoolPerRoute == null ? 20 : connectionPoolPerRoute;
        return this;
    }

    public ApiClientBuilder withProxy(String proxyHost, int proxyPort) {
        this.proxyUrl = proxyHost != null ? "http://" + proxyHost + ":" + proxyPort : null;
        return this;
    }

    public ApiClientBuilder withProxyCredentials(String proxyUser, String proxyPassword) {
        this.proxyUser = proxyUser;
        this.proxyPassword = proxyPassword;
        return this;
    }

    public ApiClientBuilder withAuthentication(String name, Authentication authentication) {
        this.authentications.put(name, authentication);
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL)
    protected ClientConfig createClientConfig(SSLContext sslContext) {
        ClientConfig clientConfig = new ClientConfig();
        this.configureJackson(clientConfig);
        if (this.proxyUrl != null) {
            this.configureProxy(clientConfig);
        }
        clientConfig.register(ApiClientJersey2RequestLogFilter.class);
        clientConfig.register(MultiPartFeature.class);
        clientConfig.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
        clientConfig.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionSocketFactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(this.connectionPoolMax);
        connectionManager.setDefaultMaxPerRoute(this.connectionPoolPerRoute);
        clientConfig.property("jersey.config.apache.client.connectionManager", (Object)connectionManager);
        clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        return clientConfig;
    }

    @API(status=API.Status.EXPERIMENTAL)
    protected void configureJackson(ClientConfig clientConfig) {
        clientConfig.register((Object)new JSON());
        clientConfig.register(JacksonFeature.class);
    }

    @API(status=API.Status.EXPERIMENTAL)
    protected void configureProxy(ClientConfig clientConfig) {
        clientConfig.property("jersey.config.client.proxy.uri", (Object)this.proxyUrl);
        clientConfig.property("jersey.config.client.proxy.username", (Object)this.proxyUser);
        clientConfig.property("jersey.config.client.proxy.password", (Object)this.proxyPassword);
    }

    @API(status=API.Status.EXPERIMENTAL)
    protected SSLContext createSSLContext() {
        try {
            SslConfigurator sslConfig = SslConfigurator.newInstance();
            if (ObjectUtils.isNotEmpty((Object)this.trustStoreBytes) && ObjectUtils.isNotEmpty((Object)this.trustStorePassword)) {
                KeyStore truststore = KeyStore.getInstance(TRUSTSTORE_FORMAT);
                truststore.load(new ByteArrayInputStream(this.trustStoreBytes), this.trustStorePassword.toCharArray());
                ApiUtils.addDefaultRootCaCertificates((KeyStore)truststore);
                sslConfig.trustStore(truststore);
                ApiUtils.logTrustStore((KeyStore)truststore);
            }
            if (ObjectUtils.isNotEmpty((Object)this.keyStoreBytes) && ObjectUtils.isNotEmpty((Object)this.keyStorePassword)) {
                sslConfig.keyStoreBytes(this.keyStoreBytes).keyStorePassword(this.keyStorePassword);
            }
            return sslConfig.createSSLContext();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException(e.getCause().getMessage(), e);
        }
    }
}

