/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.http.jersey2;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.ext.Provider;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@API(status=API.Status.INTERNAL)
public class ApiClientJersey2RequestLogFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final Logger log = LoggerFactory.getLogger((String)"com.symphony.bdk.requests.outgoing");
    private static final String INTERNAL_CLIENT_REQUEST_START_TIME = "X-BDK-internal-request-start-time";
    private static final String INTERNAL_REQUEST_LOG_MESSAGE = "status={}, url={}, time={}";

    public void filter(ClientRequestContext requestContext) {
        if (log.isDebugEnabled()) {
            requestContext.setProperty(INTERNAL_CLIENT_REQUEST_START_TIME, (Object)System.currentTimeMillis());
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) {
        Long startTimeRequest;
        if (log.isDebugEnabled() && (startTimeRequest = (Long)requestContext.getProperty(INTERNAL_CLIENT_REQUEST_START_TIME)) != null) {
            long totalRequestTime = System.currentTimeMillis() - startTimeRequest;
            log.debug(INTERNAL_REQUEST_LOG_MESSAGE, new Object[]{responseContext.getStatus(), requestContext.getUri(), totalRequestTime});
        }
    }
}

