/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.template.api;

import com.symphony.bdk.template.api.Template;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public interface TemplateEngine {
    public Template newTemplateFromFile(String var1);

    public Template newTemplateFromClasspath(String var1);

    public static TemplateEngine getDefaultImplementation() {
        ServiceLoader<TemplateEngine> engineServiceLoader = ServiceLoader.load(TemplateEngine.class);
        List templateEngines = StreamSupport.stream(engineServiceLoader.spliterator(), false).collect(Collectors.toList());
        if (templateEngines.isEmpty()) {
            throw new IllegalStateException("No TemplateEngine implementation found in classpath. Please add a symphony-bdk-template-* (freemarker or handlebars) dependency to your project.");
        }
        if (templateEngines.size() > 1) {
            throw new IllegalStateException("More than 1 TemplateEngine implementation found in classpath. Please remove the extra symphony-bdk-template-* dependency from your project");
        }
        return (TemplateEngine)templateEngines.stream().findFirst().get();
    }
}

