/*
 * Decompiled with CFR 0.152.
 */
package com.symphony.bdk.template.api;

import com.symphony.bdk.template.api.Template;
import com.symphony.bdk.template.api.TemplateEngine;
import com.symphony.bdk.template.api.TemplateException;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.INTERNAL)
public class TemplateResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TemplateResolver.class);
    private final TemplateEngine templateEngine;

    public TemplateResolver() {
        this(TemplateEngine.getDefaultImplementation());
    }

    public TemplateResolver(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public Template resolve(String template) {
        Template resolved = this.tryFetchTemplateFromClasspath(template);
        if (resolved == null) {
            resolved = this.tryFetchTemplateFromFileSystem(template);
        }
        if (resolved == null) {
            throw new TemplateException("Template " + template + " not found");
        }
        return resolved;
    }

    private Template tryFetchTemplateFromClasspath(String template) {
        try {
            return this.templateEngine.newTemplateFromClasspath(template);
        }
        catch (TemplateException e) {
            log.debug("{} is not found in classpath", (Object)template);
            return null;
        }
    }

    private Template tryFetchTemplateFromFileSystem(String template) {
        try {
            return this.templateEngine.newTemplateFromFile(template);
        }
        catch (TemplateException e) {
            log.debug("{} is not found on file system", (Object)template);
            return null;
        }
    }
}

