/*
 * Decompiled with CFR 0.152.
 */
package org.finos.toolbox.lifecycle;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.finos.toolbox.lifecycle.DefaultEdge;
import org.finos.toolbox.lifecycle.DefaultNode;
import org.finos.toolbox.lifecycle.DefaultNode$;
import org.finos.toolbox.lifecycle.SimpleTopoSort;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d\u0001B\r\u001b\u0001\rB\u0001\"\u000e\u0001\u0003\u0002\u0004%\tA\u000e\u0005\t#\u0002\u0011\t\u0019!C\u0001%\"A\u0001\f\u0001B\u0001B\u0003&q\u0007\u0003\u0005Z\u0001\t\u0005\r\u0011\"\u0001[\u0011!\t\u0007A!a\u0001\n\u0003\u0011\u0007\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0015B.\t\u000b\u0015\u0004A\u0011\u00024\t\u000f)\u0004!\u0019!C\u0005W\"1\u0001\u0010\u0001Q\u0001\n1DQ!\u001a\u0001\u0005\u0002eDQA\u001f\u0001\u0005\u0002mDQa \u0001\u0005\u0002eDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\u0019\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003o\u0001A\u0011AA\u001d\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003Bq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002N\u0001!\t!a\u0014\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA0\u0001\u0011\u0005\u0011\u0011\r\u0002\u0015\t&\u0014Xm\u0019;fI\u0006\u001b\u0017p\u00197jG\u001e\u0013\u0018\r\u001d5\u000b\u0005ma\u0012!\u00037jM\u0016\u001c\u0017p\u00197f\u0015\tib$A\u0004u_>d'm\u001c=\u000b\u0005}\u0001\u0013!\u00024j]>\u001c(\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005\u0011B5c\u0001\u0001&WA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\u0004\"\u0001L\u001a\u000e\u00035R!AL\u0018\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005A\n\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003I\n1aY8n\u0013\t!TFA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\bK\u0012<WmU3u+\u00059\u0004c\u0001\u001d@\u0005:\u0011\u0011(\u0010\t\u0003u\u001dj\u0011a\u000f\u0006\u0003y\t\na\u0001\u0010:p_Rt\u0014B\u0001 (\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0004'\u0016$(B\u0001 (!\r\u0019EIR\u0007\u00025%\u0011QI\u0007\u0002\f\t\u00164\u0017-\u001e7u\u000b\u0012<W\r\u0005\u0002H\u00112\u0001A!B%\u0001\u0005\u0004Q%\u0001\u0002(P\t\u0016\u000b\"a\u0013(\u0011\u0005\u0019b\u0015BA'(\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AJ(\n\u0005A;#aA!os\u0006YQ\rZ4f'\u0016$x\fJ3r)\t\u0019f\u000b\u0005\u0002')&\u0011Qk\n\u0002\u0005+:LG\u000fC\u0004X\u0005\u0005\u0005\t\u0019A\u001c\u0002\u0007a$\u0013'\u0001\u0005fI\u001e,7+\u001a;!\u0003\u001dqw\u000eZ3NCB,\u0012a\u0017\t\u0005qq3e,\u0003\u0002^\u0003\n\u0019Q*\u00199\u0011\u0007\r{f)\u0003\u0002a5\tYA)\u001a4bk2$hj\u001c3f\u0003-qw\u000eZ3NCB|F%Z9\u0015\u0005M\u001b\u0007bB,\u0006\u0003\u0003\u0005\raW\u0001\t]>$W-T1qA\u00051A(\u001b8jiz\"2a\u001a5j!\r\u0019\u0005A\u0012\u0005\u0006k\u001d\u0001\ra\u000e\u0005\u00063\u001e\u0001\raW\u0001\bG>,h\u000e^3s+\u0005a\u0007CA7w\u001b\u0005q'BA8q\u0003\u0019\tGo\\7jG*\u0011\u0011O]\u0001\u000bG>t7-\u001e:sK:$(BA:u\u0003\u0011)H/\u001b7\u000b\u0003U\fAA[1wC&\u0011qO\u001c\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002\u0011\r|WO\u001c;fe\u0002\"\u0012aZ\u0001\bSN,U\u000e\u001d;z+\u0005a\bC\u0001\u0014~\u0013\tqxEA\u0004C_>dW-\u00198\u0002\t\r|\u0007/_\u0001\u001cO\u0016$hj\u001c3fg^KG\u000f\u001b(p\u0013:\u001cw.\\5oO\u0016#w-Z:\u0015\u0005\u0005\u0015\u0001#BA\u0004\u0003#1e\u0002BA\u0005\u0003\u001bq1AOA\u0006\u0013\u0005A\u0013bAA\bO\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\n\u0003+\u0011A\u0001T5ti*\u0019\u0011qB\u0014\u0002\u0015I,Wn\u001c<f\u001d>$W\rF\u0002T\u00037Aa!!\b\u000f\u0001\u00041\u0015!\u00018\u0002\u0019\r|g\u000e^1j]Ntu\u000eZ3\u0015\u0007q\f\u0019\u0003\u0003\u0004\u0002\u001e=\u0001\rAR\u0001\rG>tG/Y5og\u0016#w-\u001a\u000b\u0006y\u0006%\u0012Q\u0006\u0005\u0007\u0003W\u0001\u0002\u0019\u0001$\u0002\u00059\f\u0004BBA\u0018!\u0001\u0007a)\u0001\u0002oe\u00059q-\u001a;O_\u0012,Gc\u00010\u00026!1\u0011QD\tA\u0002\u0019\u000b!B]3n_Z,W\tZ4f)\r\u0019\u00161\b\u0005\u0007\u0003{\u0011\u0002\u0019\u0001\"\u0002\t\u0015$w-Z\u0001\bC\u0012$gj\u001c3f)\r\u0019\u00161\t\u0005\u0007\u0003;\u0019\u0002\u0019\u0001$\u0002\u000f\u0005$G-\u00123hKR)1+!\u0013\u0002L!1\u0011Q\u0004\u000bA\u0002\u0019Ca!a\f\u0015\u0001\u00041\u0015!\u0002:p_R\u001cXCAA)!\u0015\t9!!\u0005_\u0003=!x\u000e]8m_\u001eL7-\u00197T_J$XCAA,!\u0019\t9!!\u0005\u0002\u0006\u0005\u0001r-\u001a;J]\u000e|W.\u001b8h\u000b\u0012<Wm\u001d\u000b\u0004o\u0005u\u0003BBA\u000f/\u0001\u0007a)\u0001\thKR|U\u000f^4pS:<W\tZ4fgR\u0019q'a\u0019\t\r\u0005u\u0001\u00041\u0001G\u0001")
public class DirectedAcyclicGraph<NODE>
implements StrictLogging {
    private Set<DefaultEdge<NODE>> edgeSet;
    private Map<NODE, DefaultNode<NODE>> nodeMap;
    private final AtomicInteger counter;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Set<DefaultEdge<NODE>> edgeSet() {
        return this.edgeSet;
    }

    public void edgeSet_$eq(Set<DefaultEdge<NODE>> x$1) {
        this.edgeSet = x$1;
    }

    public Map<NODE, DefaultNode<NODE>> nodeMap() {
        return this.nodeMap;
    }

    public void nodeMap_$eq(Map<NODE, DefaultNode<NODE>> x$1) {
        this.nodeMap = x$1;
    }

    private AtomicInteger counter() {
        return this.counter;
    }

    public boolean isEmpty() {
        return this.nodeMap().isEmpty();
    }

    public DirectedAcyclicGraph<NODE> copy() {
        return new DirectedAcyclicGraph<NODE>(this.edgeSet(), this.nodeMap());
    }

    public List<NODE> getNodesWithNoIncomingEdges() {
        return ((IterableOnceOps)((IterableOps)this.nodeMap().values().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DirectedAcyclicGraph.$anonfun$getNodesWithNoIncomingEdges$1(x$2)))).map((Function1 & Serializable)n -> n.n())).toList();
    }

    public void removeNode(NODE n) {
        Option option = this.nodeMap().get(n);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            DefaultNode node = (DefaultNode)some.value();
            node.outgoingEdges().foreach((Function1 & Serializable)x$3 -> {
                this.removeEdge(x$3);
                return BoxedUnit.UNIT;
            });
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("removing node {}", (Object)node);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.nodeMap_$eq((Map)this.nodeMap().$minus(node.n()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Node not found in graph {}", n);
                return;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public boolean containsNode(NODE n) {
        return this.nodeMap().contains(n);
    }

    public boolean containsEdge(NODE n1, NODE n2) {
        DefaultEdge<NODE> edge = new DefaultEdge<NODE>(n1, n2);
        return this.edgeSet().contains(edge);
    }

    public DefaultNode<NODE> getNode(NODE n) {
        return (DefaultNode)this.nodeMap().get(n).get();
    }

    public void removeEdge(DefaultEdge<NODE> edge) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("removing edge {}", edge);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        DefaultNode<NODE> sinkNode = this.getNode(edge.sinkNode());
        Set x$1 = (Set)sinkNode.incomingEdges().$minus(edge);
        NODE x$2 = sinkNode.copy$default$1();
        int x$3 = sinkNode.copy$default$2();
        Set<DefaultEdge<NODE>> x$4 = sinkNode.copy$default$4();
        DefaultNode<NODE> newSink = sinkNode.copy(x$2, x$3, x$1, x$4);
        this.nodeMap_$eq((Map)this.nodeMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(newSink.n()), newSink)));
    }

    public void addNode(NODE n) {
        this.nodeMap_$eq((Map)this.nodeMap().$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(n), new DefaultNode<NODE>(n, this.counter().getAndIncrement(), DefaultNode$.MODULE$.apply$default$3(), DefaultNode$.MODULE$.apply$default$4()))}))));
    }

    public void addEdge(NODE n, NODE n2) {
        if (!this.nodeMap().contains(n)) {
            this.nodeMap_$eq((Map)this.nodeMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(n), new DefaultNode<NODE>(n, this.counter().getAndIncrement(), DefaultNode$.MODULE$.apply$default$3(), DefaultNode$.MODULE$.apply$default$4()))));
        }
        if (!this.nodeMap().contains(n2)) {
            this.nodeMap_$eq((Map)this.nodeMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(n2), new DefaultNode<NODE>(n2, this.counter().getAndIncrement(), DefaultNode$.MODULE$.apply$default$3(), DefaultNode$.MODULE$.apply$default$4()))));
        }
        DefaultEdge<NODE> edge = new DefaultEdge<NODE>(n, n2);
        if (!this.edgeSet().contains(edge)) {
            this.edgeSet_$eq((Set)this.edgeSet().$plus(edge));
        }
        DefaultNode node1 = (DefaultNode)this.nodeMap().get(n).get();
        DefaultNode node2 = (DefaultNode)this.nodeMap().get(n2).get();
        node1.outgoingEdges_$eq((Set)node1.outgoingEdges().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefaultEdge[]{edge}))));
        node2.incomingEdges_$eq((Set)node2.incomingEdges().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DefaultEdge[]{edge}))));
    }

    public List<DefaultNode<NODE>> roots() {
        return ((IterableOnceOps)((IterableOps)this.nodeMap().values().filter((Function1 & Serializable)n -> BoxesRunTime.boxToBoolean((boolean)DirectedAcyclicGraph.$anonfun$roots$1(n)))).map((Function1 & Serializable)node -> node)).toList();
    }

    public List<List<NODE>> topologicalSort() {
        return new SimpleTopoSort(this).sort();
    }

    public Set<DefaultEdge<NODE>> getIncomingEdges(NODE n) {
        Option option = this.nodeMap().get(n);
        if (option instanceof Some) {
            Some some = (Some)option;
            DefaultNode node = (DefaultNode)some.value();
            return node.incomingEdges();
        }
        if (None$.MODULE$.equals(option)) {
            return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    public Set<DefaultEdge<NODE>> getOutgoingEdges(NODE n) {
        Option option = this.nodeMap().get(n);
        if (option instanceof Some) {
            Some some = (Some)option;
            DefaultNode node = (DefaultNode)some.value();
            return node.outgoingEdges();
        }
        if (None$.MODULE$.equals(option)) {
            return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ boolean $anonfun$getNodesWithNoIncomingEdges$1(DefaultNode x$2) {
        return x$2.incomingEdges().size() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$roots$1(DefaultNode n) {
        return n.incomingEdges().size() == 0;
    }

    private DirectedAcyclicGraph(Set<DefaultEdge<NODE>> edgeSet, Map<NODE, DefaultNode<NODE>> nodeMap) {
        this.edgeSet = edgeSet;
        this.nodeMap = nodeMap;
        StrictLogging.$init$((StrictLogging)this);
        this.counter = new AtomicInteger(0);
        Statics.releaseFence();
    }

    public DirectedAcyclicGraph() {
        this((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
    }
}

