/*
 * Decompiled with CFR 0.152.
 */
package org.finos.toolbox.lifecycle;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.finos.toolbox.lifecycle.DirectedAcyclicGraph;
import org.finos.toolbox.lifecycle.LifeCycleComponentContext;
import org.finos.toolbox.lifecycle.LifecycleEnabled;
import org.finos.toolbox.thread.Runner;
import org.finos.toolbox.thread.Runner$;
import org.finos.toolbox.time.Clock;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005Y4A!\u0005\n\u00017!AA\u0006\u0001B\u0001B\u0003-Q\u0006C\u00034\u0001\u0011\u0005A\u0007C\u0004:\u0001\t\u0007I\u0011\u0001\u001e\t\r\u0001\u0003\u0001\u0015!\u0003<\u0011\u001d\t\u0005A1A\u0005\n\tCa!\u0013\u0001!\u0002\u0013\u0019\u0005\"\u0002&\u0001\t\u0003Y\u0005\"B(\u0001\t\u0003\u0001\u0006\"\u0002,\u0001\t\u00039\u0006\"\u0002.\u0001\t\u0003Y\u0005\"B.\u0001\t\u0013a\u0006\"B6\u0001\t\u0013a\u0007\"\u00028\u0001\t\u0013y\u0007\"B9\u0001\t\u0013\u0011\b\"\u0002;\u0001\t\u0003Y\u0005\"B;\u0001\t\u0003Y%A\u0005'jM\u0016\u001c\u0017p\u00197f\u0007>tG/Y5oKJT!a\u0005\u000b\u0002\u00131Lg-Z2zG2,'BA\u000b\u0017\u0003\u001d!xn\u001c7c_bT!a\u0006\r\u0002\u000b\u0019Lgn\\:\u000b\u0003e\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u000f#!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fMB\u00111EK\u0007\u0002I)\u0011QEJ\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003O!\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002S\u0005\u00191m\\7\n\u0005-\"#!D*ue&\u001cG\u000fT8hO&tw-A\u0003dY>\u001c7\u000e\u0005\u0002/c5\tqF\u0003\u00021)\u0005!A/[7f\u0013\t\u0011tFA\u0003DY>\u001c7.\u0001\u0004=S:LGO\u0010\u000b\u0002kQ\u0011a\u0007\u000f\t\u0003o\u0001i\u0011A\u0005\u0005\u0006Y\t\u0001\u001d!L\u0001\u0007i\"\u0014X-\u00193\u0016\u0003m\u0002\"\u0001\u0010 \u000e\u0003uR!!\u000f\u000b\n\u0005}j$A\u0002*v]:,'/A\u0004uQJ,\u0017\r\u001a\u0011\u0002\u001f\u0011,\u0007/\u001a8eK:\u001c\u0017p\u0012:ba\",\u0012a\u0011\t\u0004o\u00113\u0015BA#\u0013\u0005Q!\u0015N]3di\u0016$\u0017iY=dY&\u001cwI]1qQB\u0011qgR\u0005\u0003\u0011J\u0011\u0001\u0003T5gK\u000eL8\r\\3F]\u0006\u0014G.\u001a3\u0002!\u0011,\u0007/\u001a8eK:\u001c\u0017p\u0012:ba\"\u0004\u0013\u0001E1vi>\u001c\u0006.\u001e;e_^t\u0007j\\8l)\u0005a\u0005CA\u000fN\u0013\tqeD\u0001\u0003V]&$\u0018!B1qa2LHCA)U!\t9$+\u0003\u0002T%\tIB*\u001b4f\u0007f\u001cG.Z\"p[B|g.\u001a8u\u0007>tG/\u001a=u\u0011\u0015)\u0006\u00021\u0001G\u0003\u0011\u0019w.\u001c9\u0002\u0007\u0005$G\r\u0006\u0002M1\")\u0011,\u0003a\u0001\r\u0006I1m\\7q_:,g\u000e^\u0001\u0006gR\f'\u000f^\u0001\u000eS:LGo\u00148f\u0005V\u001c7.\u001a;\u0015\u00051k\u0006\"\u00020\f\u0001\u0004y\u0016!D:uCJ$8+Z9vK:\u001cW\rE\u0002aQ\u001as!!\u00194\u000f\u0005\t,W\"A2\u000b\u0005\u0011T\u0012A\u0002\u001fs_>$h(C\u0001 \u0013\t9g$A\u0004qC\u000e\\\u0017mZ3\n\u0005%T'\u0001\u0002'jgRT!a\u001a\u0010\u0002\u001dM$\u0018M\u001d;P]\u0016\u0014UoY6fiR\u0011A*\u001c\u0005\u0006=2\u0001\raX\u0001\u000egR|\u0007o\u00148f\u0005V\u001c7.\u001a;\u0015\u00051\u0003\b\"\u00020\u000e\u0001\u0004y\u0016\u0001\u00053fgR\u0014x._(oK\n+8m[3u)\ta5\u000fC\u0003_\u001d\u0001\u0007q,\u0001\u0003k_&t\u0017\u0001B:u_B\u0004")
public class LifecycleContainer
implements StrictLogging {
    private final Runner thread;
    private final DirectedAcyclicGraph<LifecycleEnabled> dependencyGraph;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Runner thread() {
        return this.thread;
    }

    private DirectedAcyclicGraph<LifecycleEnabled> dependencyGraph() {
        return this.dependencyGraph;
    }

    public void autoShutdownHook() {
        LifecycleContainer container = this;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this, container){
            private final /* synthetic */ LifecycleContainer $outer;
            private final LifecycleContainer container$1;

            public void run() {
                this.$outer.thread().stop();
                this.container$1.stop();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.container$1 = container$1;
            }
        }, "lcShutdownHook"));
    }

    public LifeCycleComponentContext apply(LifecycleEnabled comp) {
        BoxedUnit boxedUnit;
        if (!this.dependencyGraph().containsNode(comp)) {
            this.dependencyGraph().addNode(comp);
            boxedUnit = BoxedUnit.UNIT;
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("lifecycle already contains component {}", (Object)comp);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new LifeCycleComponentContext(comp, this, this.dependencyGraph());
    }

    public void add(LifecycleEnabled component) {
    }

    public void start() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Starting lifecycle");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        List<List<LifecycleEnabled>> sort = this.dependencyGraph().topologicalSort();
        List startSequence = sort.reverse();
        startSequence.foreach((Function1 & Serializable)list -> {
            this.initOneBucket((List<LifecycleEnabled>)list);
            return BoxedUnit.UNIT;
        });
        startSequence.foreach((Function1 & Serializable)list -> {
            this.startOneBucket((List<LifecycleEnabled>)list);
            return BoxedUnit.UNIT;
        });
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Started lifecycle");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void initOneBucket(List<LifecycleEnabled> startSequence) {
        startSequence.foreach((Function1 & Serializable)comp -> {
            LifecycleContainer.$anonfun$initOneBucket$1(this, comp);
            return BoxedUnit.UNIT;
        });
    }

    private void startOneBucket(List<LifecycleEnabled> startSequence) {
        startSequence.foreach((Function1 & Serializable)comp -> {
            LifecycleContainer.$anonfun$startOneBucket$1(this, comp);
            return BoxedUnit.UNIT;
        });
    }

    private void stopOneBucket(List<LifecycleEnabled> startSequence) {
        startSequence.reverse().foreach((Function1 & Serializable)comp -> {
            LifecycleContainer.$anonfun$stopOneBucket$1(this, comp);
            return BoxedUnit.UNIT;
        });
    }

    private void destroyOneBucket(List<LifecycleEnabled> startSequence) {
        startSequence.reverse().foreach((Function1 & Serializable)comp -> {
            LifecycleContainer.$anonfun$destroyOneBucket$1(this, comp);
            return BoxedUnit.UNIT;
        });
    }

    public void join() {
        this.thread().join();
    }

    public void stop() {
        BoxedUnit boxedUnit;
        List<List<LifecycleEnabled>> sort;
        List<List<LifecycleEnabled>> startSequence = sort = this.dependencyGraph().topologicalSort();
        startSequence.foreach((Function1 & Serializable)list -> {
            this.stopOneBucket((List<LifecycleEnabled>)list);
            return BoxedUnit.UNIT;
        });
        startSequence.foreach((Function1 & Serializable)list -> {
            this.destroyOneBucket((List<LifecycleEnabled>)list);
            return BoxedUnit.UNIT;
        });
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Shutdown lifecycle");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$initOneBucket$1(LifecycleContainer $this, LifecycleEnabled comp) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Initializing {} {}", new Object[]{comp.getClass(), comp.lifecycleId()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        comp.doInitialize();
    }

    public static final /* synthetic */ void $anonfun$startOneBucket$1(LifecycleContainer $this, LifecycleEnabled comp) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Starting {} {}", new Object[]{comp.getClass(), comp.lifecycleId()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        comp.doStart();
    }

    public static final /* synthetic */ void $anonfun$stopOneBucket$1(LifecycleContainer $this, LifecycleEnabled comp) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Stopping {} {}", new Object[]{comp.getClass(), comp.lifecycleId()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        comp.doStop();
    }

    public static final /* synthetic */ void $anonfun$destroyOneBucket$1(LifecycleContainer $this, LifecycleEnabled comp) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Destroying {}", comp.getClass());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        comp.doDestroy();
    }

    public LifecycleContainer(Clock clock) {
        StrictLogging.$init$((StrictLogging)this);
        this.thread = new Runner("lifeCycleJoinRunner", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> Thread.sleep(1000L), Runner$.MODULE$.$lessinit$greater$default$3(), Runner$.MODULE$.$lessinit$greater$default$4(), clock);
        this.thread().runInBackground();
        this.dependencyGraph = new DirectedAcyclicGraph();
        Statics.releaseFence();
    }
}

