/*
 * Decompiled with CFR 0.152.
 */
package org.finos.toolbox.lifecycle;

import java.io.PrintWriter;
import java.io.Serializable;
import org.finos.toolbox.lifecycle.DefaultEdge;
import org.finos.toolbox.lifecycle.DefaultNode;
import org.finos.toolbox.lifecycle.DirectedAcyclicGraph;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.runtime.BoxedUnit;

public final class LifecycleGraphviz$ {
    public static final LifecycleGraphviz$ MODULE$ = new LifecycleGraphviz$();

    public <NODE> void apply(String name, DirectedAcyclicGraph<NODE> graph) {
        String fileName = new StringBuilder(4).append(name).append(".txt").toString();
        PrintWriter pw = new PrintWriter(fileName);
        Predef$.MODULE$.println((Object)new StringBuilder(24).append("Writing the graphviz to ").append(fileName).toString());
        this.writeHeader(name, pw);
        ((IterableOnceOps)graph.nodeMap().values().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            LifecycleGraphviz$.$anonfun$apply$1(pw, x0$1);
            return BoxedUnit.UNIT;
        });
        graph.roots().foreach((Function1 & Serializable)root -> {
            LifecycleGraphviz$.MODULE$.writeVertex(graph, root, pw);
            return BoxedUnit.UNIT;
        });
        this.writeFooter(pw);
        pw.close();
    }

    private <NODE> void writeVertex(DirectedAcyclicGraph<NODE> graph, DefaultNode<NODE> node, PrintWriter pw) {
        node.outgoingEdges().foreach((Function1 & Serializable)child -> {
            LifecycleGraphviz$.$anonfun$writeVertex$1(node, graph, pw, child);
            return BoxedUnit.UNIT;
        });
    }

    private void writeHeader(String name, PrintWriter pw) {
        pw.write("digraph regexp { \n");
        pw.write("\t rankdir=\"LR\"");
        pw.write("\t node [fontsize=10, shape=box, height=0.25]");
        pw.write("\t edge [fontsize=10]");
    }

    private <NODE> void writeNode(int i, NODE n, PrintWriter pw) {
        String nodeAsString = n.toString().replace(".", "").replace("@", "_");
        String nodeName = new StringBuilder(1).append("n").append(nodeAsString.replace(".", "").replace("@", "_")).toString();
        String str = new StringBuilder(112).append("\t ").append(nodeName).append(" [label=\"").append(nodeAsString).append("\", URL=\"https://godoc.org/regexp\", tooltip=\"Package regexp implements regular expression search.\"]; \n").toString();
        pw.write(str);
    }

    private void writeFooter(PrintWriter pw) {
        pw.write("}");
    }

    public static final /* synthetic */ void $anonfun$apply$1(PrintWriter pw$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            DefaultNode node = (DefaultNode)tuple2._1();
            int i = tuple2._2$mcI$sp();
            MODULE$.writeNode(i, node.n(), pw$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$writeVertex$1(DefaultNode node$1, DirectedAcyclicGraph graph$2, PrintWriter pw$2, DefaultEdge child) {
        String parentName = new StringBuilder(1).append("n").append(node$1.n().toString().replace(".", "").replace("@", "_")).toString();
        DefaultNode childNode = graph$2.getNode(child.sinkNode());
        String childName = new StringBuilder(1).append("n").append(childNode.n().toString().replace(".", "").replace("@", "_")).toString();
        pw$2.write(new StringBuilder(10).append("\t ").append(parentName).append(" -> ").append(childName).append(" ; \n").toString());
        MODULE$.writeVertex(graph$2, childNode, pw$2);
    }

    private LifecycleGraphviz$() {
    }
}

