/*
 * Decompiled with CFR 0.152.
 */
package org.finos.toolbox.thread;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.util.concurrent.atomic.AtomicBoolean;
import org.finos.toolbox.NamedThreadFactory;
import org.finos.toolbox.thread.Runner$;
import org.finos.toolbox.time.Clock;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005mb\u0001B\f\u0019\u0001\u0005B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!i\u0005A!A!\u0002\u0017q\u0005\"\u0002+\u0001\t\u0003)\u0006bB\r\u0001\u0005\u0004%IA\u0018\u0005\u0007O\u0002\u0001\u000b\u0011B0\t\u000f!\u0004!\u0019!C\u0005S\"1A\u000f\u0001Q\u0001\n)DQ!\u001e\u0001\u0005\u0002YDQa\u001f\u0001\u0005\u0002qDQ! \u0001\u0005\u0002qDQA \u0001\u0005\u0002qDaa \u0001\u0005\u0002\u0005\u0005\u0001BBA\u0005\u0001\u0011\u0005A\u0010C\u0004\u0002\f\u0001!\t\"!\u0004\b\u0013\u0005U\u0001$!A\t\u0002\u0005]a\u0001C\f\u0019\u0003\u0003E\t!!\u0007\t\rQ\u001bB\u0011AA\u000e\u0011%\tibEI\u0001\n\u0003\ty\u0002C\u0005\u00026M\t\n\u0011\"\u0001\u00028\t1!+\u001e8oKJT!!\u0007\u000e\u0002\rQD'/Z1e\u0015\tYB$A\u0004u_>d'm\u001c=\u000b\u0005uq\u0012!\u00024j]>\u001c(\"A\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011\u0003\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003SAj\u0011A\u000b\u0006\u0003W1\nAb]2bY\u0006dwnZ4j]\u001eT!!\f\u0018\u0002\u0011QL\b/Z:bM\u0016T\u0011aL\u0001\u0004G>l\u0017BA\u0019+\u00055\u0019FO]5di2{wmZ5oO\u0006!a.Y7f!\t!4H\u0004\u00026sA\u0011a\u0007J\u0007\u0002o)\u0011\u0001\bI\u0001\u0007yI|w\u000e\u001e \n\u0005i\"\u0013A\u0002)sK\u0012,g-\u0003\u0002={\t11\u000b\u001e:j]\u001eT!A\u000f\u0013\u0002\t\u0019,hn\u0019\t\u0004G\u0001\u0013\u0015BA!%\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002$\u0007&\u0011A\t\n\u0002\u0005+:LG/\u0001\u0007nS:\u001c\u0015p\u00197f)&lW\r\u0005\u0002$\u000f&\u0011\u0001\n\n\u0002\u0005\u0019>tw-A\u0004sk:|enY3\u0011\u0005\rZ\u0015B\u0001'%\u0005\u001d\u0011un\u001c7fC:\fQa\u00197pG.\u0004\"a\u0014*\u000e\u0003AS!!\u0015\u000e\u0002\tQLW.Z\u0005\u0003'B\u0013Qa\u00117pG.\fa\u0001P5oSRtD#\u0002,[7rkFCA,Z!\tA\u0006!D\u0001\u0019\u0011\u0015ie\u0001q\u0001O\u0011\u0015\u0011d\u00011\u00014\u0011\u0015qd\u00011\u0001@\u0011\u001d)e\u0001%AA\u0002\u0019Cq!\u0013\u0004\u0011\u0002\u0003\u0007!*F\u0001`!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0003mC:<'\"\u00013\u0002\t)\fg/Y\u0005\u0003M\u0006\u0014a\u0001\u00165sK\u0006$\u0017a\u0002;ie\u0016\fG\rI\u0001\u000fg\"|W\u000f\u001c3D_:$\u0018N\\;f+\u0005Q\u0007CA6s\u001b\u0005a'BA7o\u0003\u0019\tGo\\7jG*\u0011q\u000e]\u0001\u000bG>t7-\u001e:sK:$(BA9d\u0003\u0011)H/\u001b7\n\u0005Md'!D!u_6L7MQ8pY\u0016\fg.A\btQ>,H\u000eZ\"p]RLg.^3!\u00039!w.T5o\u0007f\u001cG.\u001a+j[\u0016$2AQ<z\u0011\u0015A8\u00021\u0001G\u0003\u0015\u0019H/\u0019:u\u0011\u0015Q8\u00021\u0001G\u0003\r)g\u000eZ\u0001\u0010eVt\u0017J\u001c\"bG.<'o\\;oIR\t!)A\u0005j]R,'O];qi\u0006!!n\\5o\u0003\r\u0011XO\u001c\u000b\u0003\u0003\u0007\u00012aIA\u0003\u0013\r\t9\u0001\n\u0002\b\u001d>$\b.\u001b8h\u0003\u0011\u0019Ho\u001c9\u0002\u0017\u001d,GOU;o]\u0006\u0014G.\u001a\u000b\u0003\u0003\u001f\u00012\u0001YA\t\u0013\r\t\u0019\"\u0019\u0002\t%Vtg.\u00192mK\u00061!+\u001e8oKJ\u0004\"\u0001W\n\u0014\u0005M\u0011CCAA\f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u0005\u0016\u0004\r\u0006\r2FAA\u0013!\u0011\t9#!\r\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=B%\u0001\u0006b]:|G/\u0019;j_:LA!a\r\u0002*\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\tIDK\u0002K\u0003G\u0001")
public class Runner
implements StrictLogging {
    public final String org$finos$toolbox$thread$Runner$$name;
    public final Function0<BoxedUnit> org$finos$toolbox$thread$Runner$$func;
    private final long minCycleTime;
    public final boolean org$finos$toolbox$thread$Runner$$runOnce;
    public final Clock org$finos$toolbox$thread$Runner$$clock;
    private final Thread thread;
    private final AtomicBoolean org$finos$toolbox$thread$Runner$$shouldContinue;
    private Logger logger;

    public static boolean $lessinit$greater$default$4() {
        return Runner$.MODULE$.$lessinit$greater$default$4();
    }

    public static long $lessinit$greater$default$3() {
        return Runner$.MODULE$.$lessinit$greater$default$3();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Thread thread() {
        return this.thread;
    }

    public AtomicBoolean org$finos$toolbox$thread$Runner$$shouldContinue() {
        return this.org$finos$toolbox$thread$Runner$$shouldContinue;
    }

    public void doMinCycleTime(long start, long end) {
        long takenMillis = end - start;
        if (takenMillis < this.minCycleTime) {
            long sleep = this.minCycleTime - takenMillis;
            this.org$finos$toolbox$thread$Runner$$clock.sleep(sleep);
            return;
        }
    }

    public void runInBackground() {
        this.thread().start();
    }

    public void interrupt() {
        this.thread().interrupt();
    }

    public void join() {
        this.thread().join();
    }

    public Nothing$ run() {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public void stop() {
        this.org$finos$toolbox$thread$Runner$$shouldContinue().set(false);
        this.thread().interrupt();
    }

    public Runnable getRunnable() {
        return new Runnable(this){
            private final /* synthetic */ Runner $outer;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                BoxedUnit boxedUnit;
                block8: {
                    try {
                        while (this.$outer.org$finos$toolbox$thread$Runner$$shouldContinue().get()) {
                            BoxedUnit boxedUnit2;
                            long start = this.$outer.org$finos$toolbox$thread$Runner$$clock.now();
                            this.$outer.org$finos$toolbox$thread$Runner$$func.apply$mcV$sp();
                            long end = this.$outer.org$finos$toolbox$thread$Runner$$clock.now();
                            this.$outer.doMinCycleTime(start, end);
                            if (Thread.interrupted() || this.$outer.org$finos$toolbox$thread$Runner$$runOnce) {
                                this.$outer.org$finos$toolbox$thread$Runner$$shouldContinue().set(false);
                                if (this.$outer.logger().underlying().isDebugEnabled()) {
                                    this.$outer.logger().underlying().debug("[{}] interrupted or run once, going to exit", (Object)this.$outer.org$finos$toolbox$thread$Runner$$name);
                                    boxedUnit2 = BoxedUnit.UNIT;
                                    continue;
                                }
                                boxedUnit2 = BoxedUnit.UNIT;
                                continue;
                            }
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof InterruptedException) {
                            if (this.$outer.logger().underlying().isDebugEnabled()) {
                                this.$outer.logger().underlying().debug("[{}] interrupted, going to exit", (Object)this.$outer.org$finos$toolbox$thread$Runner$$name);
                            }
                        }
                        if (throwable2 == null) throw throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) throw throwable;
                        Throwable e = (Throwable)option.get();
                        if (!this.$outer.logger().underlying().isErrorEnabled()) break block8;
                        this.$outer.logger().underlying().error(new StringBuilder(28).append("[").append(this.$outer.org$finos$toolbox$thread$Runner$$name).append("] threw an exception in run").toString(), e);
                    }
                }
                if (this.$outer.logger().underlying().isInfoEnabled()) {
                    this.$outer.logger().underlying().info("[{}] is exiting", (Object)this.$outer.org$finos$toolbox$thread$Runner$$name);
                    boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public Runner(String name, Function0<BoxedUnit> func, long minCycleTime, boolean runOnce, Clock clock) {
        this.org$finos$toolbox$thread$Runner$$name = name;
        this.org$finos$toolbox$thread$Runner$$func = func;
        this.minCycleTime = minCycleTime;
        this.org$finos$toolbox$thread$Runner$$runOnce = runOnce;
        this.org$finos$toolbox$thread$Runner$$clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.thread = new NamedThreadFactory(name).newThread(this.getRunnable());
        this.org$finos$toolbox$thread$Runner$$shouldContinue = new AtomicBoolean(true);
        Statics.releaseFence();
    }
}

