/*
 * Decompiled with CFR 0.152.
 */
package org.finos.toolbox.thread.executor;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.finos.toolbox.NamedThreadFactory;
import org.finos.toolbox.logging.LogAtFrequency;
import org.finos.toolbox.thread.WorkItem;
import org.finos.toolbox.time.Clock;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005me!\u0002\u000b\u0016\u0003\u0003\u0001\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015C\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011!I\u0007A!A!\u0002\u0017Q\u0007\"\u00029\u0001\t\u0003\t\b\"CA\b\u0001\t\u0007I\u0011BA\t\u0011!\ty\u0002\u0001Q\u0001\n\u0005M\u0001\"CA\u0011\u0001\t\u0007I\u0011BA\u0012\u0011!\t\t\u0004\u0001Q\u0001\n\u0005\u0015\u0002bBA\u001a\u0001\u0011\u0005\u0013Q\u0007\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\tI\u0005\u0001C!\u0003\u0017Bq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002r\u00011\t!a\u001d\t\u000f\u0005}\u0004A\"\u0001\u0002\u0002\"9\u0011Q\u0012\u0001\u0007\u0002\u0005=%\u0001\u0005*fgV\u0014W.\u001b;Fq\u0016\u001cW\u000f^8s\u0015\t1r#\u0001\u0005fq\u0016\u001cW\u000f^8s\u0015\tA\u0012$\u0001\u0004uQJ,\u0017\r\u001a\u0006\u00035m\tq\u0001^8pY\n|\u0007P\u0003\u0002\u001d;\u0005)a-\u001b8pg*\ta$A\u0002pe\u001e\u001c\u0001!\u0006\u0002\"oN\u0019\u0001A\t\u0017\u0011\u0005\rRS\"\u0001\u0013\u000b\u0005\u00152\u0013AC2p]\u000e,(O]3oi*\u0011q\u0005K\u0001\u0005kRLGNC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-\"#A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_J\u0004\"!\f\u001b\u000e\u00039R!a\f\u0019\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005E\u0012\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003M\n1aY8n\u0013\t)dFA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u0005]\u0006lW\r\u0005\u00029\u0003:\u0011\u0011h\u0010\t\u0003uuj\u0011a\u000f\u0006\u0003y}\ta\u0001\u0010:p_Rt$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k\u0014A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\u001f\u0002\u0019\r|'/\u001a)p_2\u001c\u0016N_3\u0011\u0005\u0019;U\"A\u001f\n\u0005!k$aA%oi\u0006YQ.\u0019=Q_>d7+\u001b>f\u00035YW-\u001a9BY&4X\rV5nKB\u0011a\tT\u0005\u0003\u001bv\u0012A\u0001T8oO\u0006AA/[7f+:LG\u000f\u0005\u0002Q9:\u0011\u0011+\u0017\b\u0003%Zs!aU+\u000f\u0005i\"\u0016\"\u0001 \n\u0005\u0015j\u0014BA,Y\u0003!!WO]1uS>t'BA\u0013>\u0013\tQ6,A\u0004qC\u000e\\\u0017mZ3\u000b\u0005]C\u0016BA/_\u0005!!\u0016.\\3V]&$(B\u0001.\\\u0003%9xN]6Rk\u0016,X\rE\u0002$C\u000eL!A\u0019\u0013\u0003\u001b\tcwnY6j]\u001e\fV/Z;f!\t!w-D\u0001f\u0015\t1\u0007&\u0001\u0003mC:<\u0017B\u00015f\u0005!\u0011VO\u001c8bE2,\u0017!B2m_\u000e\\\u0007CA6o\u001b\u0005a'BA7\u001a\u0003\u0011!\u0018.\\3\n\u0005=d'!B\"m_\u000e\\\u0017A\u0002\u001fj]&$h\bF\u0007s\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0011Q\u0002\u000b\u0004g\u0006\u0005\u0001c\u0001;\u0001k6\tQ\u0003\u0005\u0002wo2\u0001A!\u0002=\u0001\u0005\u0004I(!\u0001+\u0012\u0005il\bC\u0001$|\u0013\taXHA\u0004O_RD\u0017N\\4\u0011\u0005\u0019s\u0018BA@>\u0005\r\te.\u001f\u0005\u0006S\"\u0001\u001dA\u001b\u0005\u0006m!\u0001\ra\u000e\u0005\u0006\t\"\u0001\r!\u0012\u0005\u0006\u0013\"\u0001\r!\u0012\u0005\u0006\u0015\"\u0001\ra\u0013\u0005\u0006\u001d\"\u0001\ra\u0014\u0005\u0006?\"\u0001\r\u0001Y\u0001\tY><WI^3ssV\u0011\u00111\u0003\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D\r\u0002\u000f1|wmZ5oO&!\u0011QDA\f\u00059aunZ!u\rJ,\u0017/^3oGf\f\u0011\u0002\\8h\u000bZ,'/\u001f\u0011\u0002\u0019MDW\u000f\u001e;j]\u001e$un\u001e8\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-B%\u0001\u0004bi>l\u0017nY\u0005\u0005\u0003_\tICA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u000eg\",H\u000f^5oO\u0012{wO\u001c\u0011\u0002\u0011MDW\u000f\u001e3po:$\"!a\u000e\u0011\u0007\u0019\u000bI$C\u0002\u0002<u\u0012A!\u00168ji\u0006Y1\u000f[;uI><hNT8x)\t\t\t\u0005E\u0003\u0002D\u0005\u00153-D\u0001'\u0013\r\t9E\n\u0002\u0005\u0019&\u001cH/\u0001\u0007bMR,'/\u0012=fGV$X\r\u0006\u0004\u00028\u00055\u0013\u0011\u000b\u0005\u0007\u0003\u001fz\u0001\u0019A2\u0002\u0003IDq!a\u0015\u0010\u0001\u0004\t)&A\u0001u!\u0011\t9&a\u0017\u000f\u0007M\u000bI&\u0003\u0002[{%!\u0011QLA0\u0005%!\u0006N]8xC\ndWM\u0003\u0002[{\u0005)!/\u001a;ssR1\u0011qGA3\u0003_Bq!a\u001a\u0011\u0001\u0004\tI'\u0001\u0005sk:t\u0017M\u00197f!\u0011\u0019\u00131N;\n\u0007\u00055DE\u0001\u0006GkR,(/\u001a+bg.Dq!a\u0015\u0011\u0001\u0004\t)&A\u0006oK^\u001c\u0015\r\u001c7bE2,GCBA;\u0003w\ni\b\u0005\u0003$\u0003o*\u0018bAA=I\tA1)\u00197mC\ndW\rC\u0004\u0002PE\u0001\r!!\u001b\t\u000f\u0005M\u0013\u00031\u0001\u0002V\u0005q1\u000f[8vY\u0012\u0014Vm];c[&$HCBAB\u0003\u0013\u000bY\tE\u0002G\u0003\u000bK1!a\">\u0005\u001d\u0011un\u001c7fC:Dq!a\u0014\u0013\u0001\u0004\tI\u0007C\u0004\u0002TI\u0001\r!!\u0016\u0002\u00179,woV8sW&#X-\u001c\u000b\u0005\u0003#\u000bI\nE\u0003\u0002\u0014\u0006UU/D\u0001\u0018\u0013\r\t9j\u0006\u0002\t/>\u00148.\u0013;f[\"9\u0011qJ\nA\u0002\u0005%\u0004")
public abstract class ResubmitExecutor<T>
extends ThreadPoolExecutor
implements StrictLogging {
    private final LogAtFrequency logEvery;
    private final AtomicBoolean shuttingDown;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private LogAtFrequency logEvery() {
        return this.logEvery;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    @Override
    public void shutdown() {
        this.shuttingDown().set(true);
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shuttingDown().set(true);
        return super.shutdownNow();
    }

    @Override
    public void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (!this.shuttingDown().get()) {
            FutureTask futureTask = (FutureTask)r;
            if (this.shouldResubmit(futureTask, t)) {
                this.retry(futureTask, t);
                if (this.logEvery().shouldLog()) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info(new StringBuilder(34).append("Finished runnable:").append(futureTask.get()).append(" resubmitting...").toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                return;
            }
            return;
        }
    }

    public void retry(FutureTask<T> runnable, Throwable t) {
        this.submit(this.newCallable(runnable, t));
    }

    public abstract Callable<T> newCallable(FutureTask<T> var1, Throwable var2);

    public abstract boolean shouldResubmit(FutureTask<T> var1, Throwable var2);

    public abstract WorkItem<T> newWorkItem(FutureTask<T> var1);

    public ResubmitExecutor(String name, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, BlockingQueue<Runnable> workQueue, Clock clock) {
        super(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, workQueue, new NamedThreadFactory(name));
        StrictLogging.$init$((StrictLogging)this);
        this.logEvery = new LogAtFrequency(5000L, clock);
        this.shuttingDown = new AtomicBoolean(false);
        Statics.releaseFence();
    }
}

