/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.testcontainers;

import java.security.NoSuchAlgorithmException;
import java.time.ZoneId;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.utility.DockerImageName;

public class FirebirdContainer<SELF extends FirebirdContainer<SELF>>
extends JdbcDatabaseContainer<SELF> {
    private static final Logger log = LoggerFactory.getLogger(FirebirdContainer.class);
    public static final String NAME = "firebird";
    public static final String ALTERNATE_NAME = "firebirdsql";
    public static final String IMAGE = "jacobalberty/firebird";
    static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"jacobalberty/firebird");
    public static final String DEFAULT_TAG = "3.0.7";
    public static final Integer FIREBIRD_PORT = 3050;
    private static final String FIREBIRD_SYSDBA = "sysdba";
    private static final int ARC4_REQUIRED_BITS = 160;
    private static final String CONNECTION_PROPERTY_AUTH_PLUGINS = "authPlugins";
    private String databaseName = "test";
    private String username = "test";
    private String password = "test";
    private boolean enableLegacyClientAuth;
    private String timeZone = ZoneId.systemDefault().getId();
    private boolean enableWireCrypt;
    private String sysdbaPassword;

    @Deprecated
    public FirebirdContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public FirebirdContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public FirebirdContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.addExposedPort(FIREBIRD_PORT);
    }

    protected void configure() {
        this.addEnv("TZ", this.timeZone);
        this.addEnv("FIREBIRD_DATABASE", this.databaseName);
        if (FIREBIRD_SYSDBA.equalsIgnoreCase(this.username)) {
            this.addEnv("ISC_PASSWORD", this.password);
        } else {
            this.addEnv("FIREBIRD_USER", this.username);
            this.addEnv("FIREBIRD_PASSWORD", this.password);
            if (this.sysdbaPassword != null) {
                this.addEnv("ISC_PASSWORD", this.sysdbaPassword);
            }
        }
        if (this.enableLegacyClientAuth) {
            this.addEnv("EnableLegacyClientAuth", "true");
            if (!this.urlParameters.containsKey(CONNECTION_PROPERTY_AUTH_PLUGINS)) {
                this.withUrlParam(CONNECTION_PROPERTY_AUTH_PLUGINS, "Srp256,Srp,Legacy_Auth");
            }
        }
        if (this.enableWireCrypt) {
            this.addEnv("EnableWireCrypt", "true");
        } else if (!FirebirdContainer.isWireEncryptionSupported()) {
            log.warn("Java Virtual Machine does not support wire protocol encryption requirements. Downgrading to EnableWireCrypt = true. To fix this, configure the JVM with unlimited strength Cryptographic Jurisdiction Policy.");
            this.addEnv("EnableWireCrypt", "true");
        }
    }

    public String getDriverClassName() {
        return "org.firebirdsql.jdbc.FBDriver";
    }

    public String getJdbcUrl() {
        String additionalUrlParams = this.constructUrlParameters("?", "&");
        return "jdbc:firebirdsql://" + this.getHost() + ":" + this.getMappedPort(FIREBIRD_PORT) + "/" + this.getDatabaseName() + additionalUrlParams;
    }

    public String getDatabaseName() {
        if (this.isRunning() && this.isFirebird25Image()) {
            String databasePath = this.getEnvMap().getOrDefault("DBPATH", "/firebird/data");
            return databasePath + "/" + this.databaseName;
        }
        return this.databaseName;
    }

    private boolean isFirebird25Image() {
        DockerImageName imageName = new DockerImageName(this.getDockerImageName());
        return imageName.getUnversionedPart().equals(IMAGE) && imageName.getVersionPart().startsWith("2.5");
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    protected String getTestQueryString() {
        return "select 1 from RDB$DATABASE";
    }

    public SELF withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return (SELF)((Object)((FirebirdContainer)this.self()));
    }

    public SELF withUsername(String username) {
        this.username = username;
        return (SELF)((Object)((FirebirdContainer)this.self()));
    }

    public SELF withPassword(String password) {
        this.password = password;
        return (SELF)((Object)((FirebirdContainer)this.self()));
    }

    public SELF withEnableLegacyClientAuth() {
        this.enableLegacyClientAuth = true;
        return (SELF)((Object)((FirebirdContainer)this.self()));
    }

    public SELF withEnableWireCrypt() {
        this.enableWireCrypt = true;
        return (SELF)((Object)((FirebirdContainer)this.self()));
    }

    public SELF withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return (SELF)((Object)((FirebirdContainer)this.self()));
    }

    public SELF withSysdbaPassword(String sysdbaPassword) {
        this.sysdbaPassword = sysdbaPassword;
        return (SELF)((Object)((FirebirdContainer)this.self()));
    }

    protected void waitUntilContainerStarted() {
        this.getWaitStrategy().waitUntilReady((WaitStrategyTarget)this);
        super.waitUntilContainerStarted();
    }

    public static boolean isWireEncryptionSupported() {
        try {
            return Cipher.getMaxAllowedKeyLength("ARC4") >= 160;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Cipher not found, JVM doesn't support encryption requirements", (Throwable)e);
            return false;
        }
    }
}

