/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.testcontainers;

import java.security.NoSuchAlgorithmException;
import java.time.ZoneId;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.utility.DockerImageName;

public class FirebirdContainer<SELF extends FirebirdContainer<SELF>>
extends JdbcDatabaseContainer<SELF> {
    private static final Logger log = LoggerFactory.getLogger(FirebirdContainer.class);
    public static final String NAME = "firebird";
    public static final String ALTERNATE_NAME = "firebirdsql";
    public static final String PROJECT_IMAGE = "firebirdsql/firebird";
    @Deprecated
    public static final String JACOB_ALBERTY_IMAGE = "jacobalberty/firebird";
    public static final String IMAGE = "firebirdsql/firebird";
    static final DockerImageName PROJECT_IMAGE_NAME = DockerImageName.parse((String)"firebirdsql/firebird");
    @Deprecated
    static final DockerImageName JACOB_ALBERTY_IMAGE_NAME = DockerImageName.parse((String)"jacobalberty/firebird");
    static final DockerImageName DEFAULT_IMAGE_NAME = PROJECT_IMAGE_NAME;
    public static final String DEFAULT_TAG = "5.0.3";
    public static final Integer FIREBIRD_PORT = 3050;
    private static final String FIREBIRD_SYSDBA = "sysdba";
    private static final int ARC4_REQUIRED_BITS = 160;
    private static final String CONNECTION_PROPERTY_AUTH_PLUGINS = "authPlugins";
    private String databaseName = "test";
    private String username = "test";
    private String password = "test";
    private boolean enableLegacyClientAuth;
    private String timeZone = ZoneId.systemDefault().getId();
    private boolean enableWireCrypt;
    private String sysdbaPassword;

    @Deprecated
    public FirebirdContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public FirebirdContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public FirebirdContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{PROJECT_IMAGE_NAME, JACOB_ALBERTY_IMAGE_NAME});
        this.addExposedPort(FIREBIRD_PORT);
    }

    protected void configure() {
        ImageVariant variant = ImageVariant.of(this.getDockerImageName());
        variant.setTimeZone(this);
        variant.setDatabaseName(this);
        variant.setUserAndPassword(this);
        if (this.enableLegacyClientAuth) {
            variant.enableLegacyAuth(this);
            if (!this.urlParameters.containsKey(CONNECTION_PROPERTY_AUTH_PLUGINS)) {
                this.withUrlParam(CONNECTION_PROPERTY_AUTH_PLUGINS, "Srp256,Srp,Legacy_Auth");
            }
        }
        if (this.enableWireCrypt) {
            variant.setWireCryptEnabled(this);
        } else if (!FirebirdContainer.isWireEncryptionSupported()) {
            log.warn("Java Virtual Machine does not support wire protocol encryption requirements. Downgrading to EnableWireCrypt = true. To fix this, configure the JVM with unlimited strength Cryptographic Jurisdiction Policy.");
            variant.setWireCryptEnabled(this);
        }
    }

    public String getDriverClassName() {
        return "org.firebirdsql.jdbc.FBDriver";
    }

    public String getJdbcUrl() {
        String additionalUrlParams = this.constructUrlParameters("?", "&");
        return "jdbc:firebirdsql://" + this.getHost() + ":" + this.getMappedPort(FIREBIRD_PORT) + "/" + this.getDatabaseName() + additionalUrlParams;
    }

    public String getDatabaseName() {
        if (this.isRunning()) {
            ImageVariant imageVariant = ImageVariant.of(this.getDockerImageName());
            switch (imageVariant.ordinal()) {
                case 1: {
                    if (this.isFirebird25Image()) {
                        String databasePath = this.getEnvMap().getOrDefault("DBPATH", "/firebird/data");
                        return databasePath + "/" + this.databaseName;
                    }
                    return this.databaseName;
                }
                case 0: {
                    if (this.databaseName.charAt(0) != '/') {
                        return "/var/lib/firebird/data/" + this.databaseName;
                    }
                    return this.databaseName;
                }
            }
        }
        return this.databaseName;
    }

    private boolean isFirebird25Image() {
        DockerImageName imageName = DockerImageName.parse((String)this.getDockerImageName());
        return imageName.getUnversionedPart().equals("firebirdsql/firebird") && imageName.getVersionPart().startsWith("2.5");
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    protected String getTestQueryString() {
        return "select 1 from RDB$DATABASE";
    }

    public SELF withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return (SELF)((Object)((FirebirdContainer)this.self()));
    }

    public SELF withUsername(String username) {
        this.username = username;
        return (SELF)((Object)((FirebirdContainer)this.self()));
    }

    public SELF withPassword(String password) {
        this.password = password;
        return (SELF)((Object)((FirebirdContainer)this.self()));
    }

    public SELF withEnableLegacyClientAuth() {
        this.enableLegacyClientAuth = true;
        return (SELF)((Object)((FirebirdContainer)this.self()));
    }

    public SELF withEnableWireCrypt() {
        this.enableWireCrypt = true;
        return (SELF)((Object)((FirebirdContainer)this.self()));
    }

    public SELF withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return (SELF)((Object)((FirebirdContainer)this.self()));
    }

    public SELF withSysdbaPassword(String sysdbaPassword) {
        this.sysdbaPassword = sysdbaPassword;
        return (SELF)((Object)((FirebirdContainer)this.self()));
    }

    protected void waitUntilContainerStarted() {
        this.getWaitStrategy().waitUntilReady((WaitStrategyTarget)this);
        super.waitUntilContainerStarted();
    }

    public static boolean isWireEncryptionSupported() {
        try {
            return Cipher.getMaxAllowedKeyLength("ARC4") >= 160;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Cipher not found, JVM doesn't support encryption requirements", (Throwable)e);
            return false;
        }
    }

    private static enum ImageVariant {
        PROJECT{

            @Override
            void setUserAndPassword(FirebirdContainer<?> container) {
                container.addEnv("FIREBIRD_USER", ((FirebirdContainer)container).username);
                container.addEnv("FIREBIRD_PASSWORD", ((FirebirdContainer)container).password);
                if (FirebirdContainer.FIREBIRD_SYSDBA.equalsIgnoreCase(((FirebirdContainer)container).username)) {
                    container.addEnv("FIREBIRD_ROOT_PASSWORD", ((FirebirdContainer)container).password);
                } else if (((FirebirdContainer)container).sysdbaPassword != null) {
                    container.addEnv("FIREBIRD_ROOT_PASSWORD", ((FirebirdContainer)container).sysdbaPassword);
                }
            }

            @Override
            void enableLegacyAuth(FirebirdContainer<?> container) {
                container.addEnv("FIREBIRD_USE_LEGACY_AUTH", "true");
            }

            @Override
            void setWireCryptEnabled(FirebirdContainer<?> container) {
                container.addEnv("FIREBIRD_CONF_WireCrypt", "Enabled");
            }
        }
        ,
        JACOBALBERTY{

            @Override
            void setUserAndPassword(FirebirdContainer<?> container) {
                if (FirebirdContainer.FIREBIRD_SYSDBA.equalsIgnoreCase(((FirebirdContainer)container).username)) {
                    container.addEnv("ISC_PASSWORD", ((FirebirdContainer)container).password);
                } else {
                    container.addEnv("FIREBIRD_USER", ((FirebirdContainer)container).username);
                    container.addEnv("FIREBIRD_PASSWORD", ((FirebirdContainer)container).password);
                    if (((FirebirdContainer)container).sysdbaPassword != null) {
                        container.addEnv("ISC_PASSWORD", ((FirebirdContainer)container).sysdbaPassword);
                    }
                }
            }

            @Override
            void enableLegacyAuth(FirebirdContainer<?> container) {
                container.addEnv("EnableLegacyClientAuth", "true");
            }

            @Override
            void setWireCryptEnabled(FirebirdContainer<?> container) {
                container.addEnv("EnableWireCrypt", "true");
            }
        };


        void setTimeZone(FirebirdContainer<?> container) {
            container.addEnv("TZ", ((FirebirdContainer)container).timeZone);
        }

        void setDatabaseName(FirebirdContainer<?> container) {
            container.addEnv("FIREBIRD_DATABASE", ((FirebirdContainer)container).databaseName);
        }

        abstract void setUserAndPassword(FirebirdContainer<?> var1);

        abstract void enableLegacyAuth(FirebirdContainer<?> var1);

        abstract void setWireCryptEnabled(FirebirdContainer<?> var1);

        static ImageVariant of(String imageNameString) {
            DockerImageName imageName = DockerImageName.parse((String)imageNameString);
            if (imageName.isCompatibleWith(PROJECT_IMAGE_NAME)) {
                return PROJECT;
            }
            if (imageName.isCompatibleWith(JACOB_ALBERTY_IMAGE_NAME)) {
                return JACOBALBERTY;
            }
            return PROJECT;
        }
    }
}

