/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.testcontainers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.firebirdsql.testcontainers.FirebirdContainer;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.JdbcDatabaseContainerProvider;
import org.testcontainers.jdbc.ConnectionUrl;
import org.testcontainers.utility.DockerImageName;

public class FirebirdContainerProvider
extends JdbcDatabaseContainerProvider {
    public static final String USER_PARAM = "user";
    public static final String PASSWORD_PARAM = "password";
    private static final Set<String> LEGACY_TAG_PREFIXES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("2.", "v2", "v3", "v4", "v5")));

    public boolean supports(String databaseType) {
        return "firebird".equals(databaseType) || "firebirdsql".equals(databaseType);
    }

    public JdbcDatabaseContainer newInstance() {
        return this.newInstance("5.0.3");
    }

    private static boolean isLegacyTag(String tag) {
        return tag.length() >= 2 && LEGACY_TAG_PREFIXES.contains(tag.substring(0, 2));
    }

    public JdbcDatabaseContainer newInstance(String tag) {
        DockerImageName imageName = FirebirdContainerProvider.isLegacyTag(tag) ? FirebirdContainer.JACOB_ALBERTY_IMAGE_NAME : FirebirdContainer.DEFAULT_IMAGE_NAME;
        return new FirebirdContainer(imageName.withTag(tag));
    }

    public JdbcDatabaseContainer newInstance(ConnectionUrl connectionUrl) {
        return this.newInstanceFromConnectionUrl(connectionUrl, USER_PARAM, PASSWORD_PARAM);
    }
}

