/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.firebirdsql.ds.FBAbstractCommonDataSource;
import org.firebirdsql.ds.FBConnectionPoolDataSource;
import org.firebirdsql.ds.FBXADataSource;
import org.firebirdsql.jdbc.FBConnectionProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String className = ref.getClassName();
        if (className.equals("org.firebirdsql.ds.FBConnectionPoolDataSource")) {
            return this.loadConnectionPoolDS(ref);
        }
        if (className.equals("org.firebirdsql.ds.FBXADataSource")) {
            return this.loadXADS(ref);
        }
        return null;
    }

    private Object loadConnectionPoolDS(Reference ref) throws Exception {
        FBConnectionPoolDataSource ds = new FBConnectionPoolDataSource();
        this.loadAbstractCommonDataSource(ds, ref);
        return ds;
    }

    private Object loadXADS(Reference ref) throws Exception {
        FBXADataSource ds = new FBXADataSource();
        this.loadAbstractCommonDataSource(ds, ref);
        return ds;
    }

    private void loadAbstractCommonDataSource(FBAbstractCommonDataSource ds, Reference ref) throws Exception {
        RefAddr propertyContent = ref.get("properties");
        if (propertyContent != null) {
            byte[] data = (byte[])propertyContent.getContent();
            FBConnectionProperties props = (FBConnectionProperties)DataSourceFactory.deserialize(data);
            ds.setConnectionProperties(props);
        }
        String oldDatabase = ds.getConnectionProperties().getDatabase();
        ds.setDescription(DataSourceFactory.getRefAddr(ref, "description"));
        ds.setServerName(DataSourceFactory.getRefAddr(ref, "serverName"));
        String portNumber = DataSourceFactory.getRefAddr(ref, "portNumber");
        if (portNumber != null) {
            ds.setPortNumber(Integer.parseInt(portNumber));
        }
        ds.setDatabaseName(DataSourceFactory.getRefAddr(ref, "databaseName"));
        ds.getConnectionProperties().setDatabase(oldDatabase);
    }

    protected static String getRefAddr(Reference ref, String type) {
        RefAddr addr = ref.get(type);
        if (addr == null) {
            return null;
        }
        Object content = addr.getContent();
        return content != null ? content.toString() : null;
    }

    protected static byte[] serialize(Object obj) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(obj);
            out.flush();
        }
        catch (IOException ex) {
            return null;
        }
        return bout.toByteArray();
    }

    protected static Object deserialize(byte[] data) {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        try {
            ObjectInputStream in = new ObjectInputStream(bin);
            return in.readObject();
        }
        catch (IOException ex) {
            return null;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }
}

