/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.sql.SQLException;
import javax.naming.BinaryRefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.firebirdsql.ds.DataSourceFactory;
import org.firebirdsql.ds.RootCommonDataSource;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.jdbc.FBConnectionProperties;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;

public abstract class FBAbstractCommonDataSource
extends RootCommonDataSource
implements FirebirdConnectionProperties {
    protected static final String REF_DATABASE_NAME = "databaseName";
    protected static final String REF_PORT_NUMBER = "portNumber";
    protected static final String REF_SERVER_NAME = "serverName";
    protected static final String REF_DESCRIPTION = "description";
    protected static final String REF_PROPERTIES = "properties";
    private String description;
    private String serverName;
    private int portNumber;
    private String databaseName;
    protected final Object lock = new Object();
    private FBConnectionProperties connectionProperties = new FBConnectionProperties();

    protected abstract void checkNotStarted() throws IllegalStateException;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getServerName() {
        Object object = this.lock;
        synchronized (object) {
            return this.serverName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setServerName(String serverName) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.serverName = serverName;
            this.setDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPortNumber() {
        Object object = this.lock;
        synchronized (object) {
            return this.portNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPortNumber(int portNumber) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.portNumber = portNumber;
            this.setDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getDatabaseName() {
        Object object = this.lock;
        synchronized (object) {
            return this.databaseName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDatabaseName(String databaseName) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.databaseName = databaseName;
            this.setDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getType() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setType(String type) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setType(type);
        }
    }

    public String getUser() {
        return this.connectionProperties.getUserName();
    }

    public void setUser(String user) {
        this.connectionProperties.setUserName(user);
    }

    public String getPassword() {
        return this.connectionProperties.getPassword();
    }

    public String getRoleName() {
        return this.connectionProperties.getRoleName();
    }

    public void setRoleName(String roleName) {
        this.connectionProperties.setRoleName(roleName);
    }

    public void setPassword(String password) {
        this.connectionProperties.setPassword(password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getCharSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getCharSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCharSet(String charSet) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setCharSet(charSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getEncoding() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getEncoding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setEncoding(String encoding) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setEncoding(encoding);
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this.getConnectTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.setConnectTimeout(seconds);
    }

    public int getConnectTimeout() {
        return this.connectionProperties.getConnectTimeout();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectionProperties.setConnectTimeout(connectTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getDatabase() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setDatabase(String database) {
        Object object = this.lock;
        synchronized (object) {
            this.connectionProperties.setDatabase(database);
        }
    }

    public int getBlobBufferSize() {
        return this.connectionProperties.getBlobBufferSize();
    }

    public void setBlobBufferSize(int bufferSize) {
        this.checkNotStarted();
        this.connectionProperties.setBlobBufferSize(bufferSize);
    }

    public String getSqlDialect() {
        return this.connectionProperties.getSqlDialect();
    }

    public void setSqlDialect(String sqlDialect) {
        this.checkNotStarted();
        this.connectionProperties.setSqlDialect(sqlDialect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUseTranslation() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionProperties.getUseTranslation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseTranslation(String translationPath) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStarted();
            this.connectionProperties.setUseTranslation(translationPath);
        }
    }

    public boolean isUseStreamBlobs() {
        return this.connectionProperties.isUseStreamBlobs();
    }

    public void setUseStreamBlobs(boolean useStreamBlobs) {
        this.checkNotStarted();
        this.connectionProperties.setUseStreamBlobs(useStreamBlobs);
    }

    public boolean isUseStandardUdf() {
        return this.connectionProperties.isUseStandardUdf();
    }

    public void setUseStandardUdf(boolean useStandardUdf) {
        this.checkNotStarted();
        this.connectionProperties.setUseStandardUdf(useStandardUdf);
    }

    public int getSocketBufferSize() {
        return this.connectionProperties.getSocketBufferSize();
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.checkNotStarted();
        this.connectionProperties.setSocketBufferSize(socketBufferSize);
    }

    public boolean isTimestampUsesLocalTimezone() {
        return this.connectionProperties.isTimestampUsesLocalTimezone();
    }

    public void setTimestampUsesLocalTimezone(boolean timestampUsesLocalTimezone) {
        this.checkNotStarted();
        this.connectionProperties.setTimestampUsesLocalTimezone(timestampUsesLocalTimezone);
    }

    @Deprecated
    public String getUserName() {
        return this.getUser();
    }

    @Deprecated
    public void setUserName(String userName) {
        this.setUser(userName);
    }

    public int getBuffersNumber() {
        return this.connectionProperties.getBuffersNumber();
    }

    public void setBuffersNumber(int buffersNumber) {
        this.checkNotStarted();
        this.connectionProperties.setBuffersNumber(buffersNumber);
    }

    public DatabaseParameterBuffer getDatabaseParameterBuffer() throws SQLException {
        return this.connectionProperties.getDatabaseParameterBuffer();
    }

    public String getTpbMapping() {
        return this.connectionProperties.getTpbMapping();
    }

    public void setTpbMapping(String tpbMapping) {
        this.checkNotStarted();
        this.connectionProperties.setTpbMapping(tpbMapping);
    }

    public int getDefaultTransactionIsolation() {
        return this.connectionProperties.getDefaultTransactionIsolation();
    }

    public void setDefaultTransactionIsolation(int defaultIsolationLevel) {
        this.checkNotStarted();
        this.connectionProperties.setDefaultTransactionIsolation(defaultIsolationLevel);
    }

    public String getDefaultIsolation() {
        return this.connectionProperties.getDefaultIsolation();
    }

    public void setDefaultIsolation(String isolation) {
        this.checkNotStarted();
        this.connectionProperties.setDefaultIsolation(isolation);
    }

    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        return this.connectionProperties.getTransactionParameters(isolation);
    }

    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        this.checkNotStarted();
        this.connectionProperties.setTransactionParameters(isolation, tpb);
    }

    public boolean isDefaultResultSetHoldable() {
        return this.connectionProperties.isDefaultResultSetHoldable();
    }

    public void setDefaultResultSetHoldable(boolean isHoldable) {
        this.checkNotStarted();
        this.connectionProperties.setDefaultResultSetHoldable(isHoldable);
    }

    public int getSoTimeout() {
        return this.connectionProperties.getSoTimeout();
    }

    public void setSoTimeout(int soTimeout) {
        this.checkNotStarted();
        this.connectionProperties.setSoTimeout(soTimeout);
    }

    public final void setNonStandardProperty(String propertyMapping) {
        this.checkNotStarted();
        this.connectionProperties.setNonStandardProperty(propertyMapping);
    }

    public final void setNonStandardProperty(String key, String value) {
        this.checkNotStarted();
        this.connectionProperties.setNonStandardProperty(key, value);
    }

    public final String getNonStandardProperty(String key) {
        return this.connectionProperties.getNonStandardProperty(key);
    }

    protected final void setDatabase() {
        StringBuilder sb = new StringBuilder();
        if (this.serverName != null && this.serverName.length() > 0) {
            sb.append("//").append(this.serverName);
            if (this.portNumber > 0) {
                sb.append(':').append(this.portNumber);
            }
            sb.append('/');
        }
        if (this.databaseName != null) {
            sb.append(this.databaseName);
        }
        if (sb.length() > 0) {
            this.connectionProperties.setDatabase(sb.toString());
        } else {
            this.connectionProperties.setDatabase(null);
        }
    }

    protected final void setConnectionProperties(FBConnectionProperties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    protected final FBConnectionProperties getConnectionProperties() {
        return this.connectionProperties;
    }

    protected static void updateReference(Reference ref, FBAbstractCommonDataSource instance) {
        ref.add(new StringRefAddr(REF_DESCRIPTION, instance.getDescription()));
        ref.add(new StringRefAddr(REF_SERVER_NAME, instance.getServerName()));
        if (instance.getPortNumber() != 0) {
            ref.add(new StringRefAddr(REF_PORT_NUMBER, Integer.toString(instance.getPortNumber())));
        }
        ref.add(new StringRefAddr(REF_DATABASE_NAME, instance.getDatabaseName()));
        byte[] data = DataSourceFactory.serialize(instance.connectionProperties);
        ref.add(new BinaryRefAddr(REF_PROPERTIES, data));
    }
}

