/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.resource.ResourceException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.firebirdsql.ds.DataSourceFactory;
import org.firebirdsql.ds.FBAbstractCommonDataSource;
import org.firebirdsql.ds.FBPooledConnection;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FBSQLException;

public class FBConnectionPoolDataSource
extends FBAbstractCommonDataSource
implements ConnectionPoolDataSource,
Referenceable {
    private volatile transient FBDataSource internalDs;

    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(this.getUser(), this.getPassword());
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        if (this.internalDs == null) {
            this.initialize();
        }
        return new FBPooledConnection(this.internalDs.getConnection(user, password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.internalDs != null) {
                return;
            }
            try {
                GDSType gdsType = GDSType.getType(this.getType());
                if (gdsType == null) {
                    gdsType = GDSFactory.getDefaultGDSType();
                }
                FBManagedConnectionFactory mcf = new FBManagedConnectionFactory(gdsType, this.getConnectionProperties());
                this.internalDs = (FBDataSource)mcf.createConnectionFactory();
                this.internalDs.setLogWriter(this.getLogWriter());
            }
            catch (ResourceException e) {
                throw new FBSQLException(e);
            }
        }
    }

    protected void checkNotStarted() {
        if (this.internalDs != null) {
            throw new IllegalStateException("DataSource already in use. Change of this property is not allowed");
        }
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), DataSourceFactory.class.getName(), null);
        FBAbstractCommonDataSource.updateReference(ref, this);
        return ref;
    }
}

