/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.event;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.firebirdsql.event.DatabaseEvent;
import org.firebirdsql.event.DatabaseEventImpl;
import org.firebirdsql.event.EventListener;
import org.firebirdsql.event.EventManager;
import org.firebirdsql.event.OneTimeEventListener;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.EventHandle;
import org.firebirdsql.gds.EventHandler;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscDbHandle;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jdbc.FBSQLException;

public class FBEventManager
implements EventManager {
    private GDS gds;
    private IscDbHandle dbHandle;
    private boolean connected = false;
    private String user = "";
    private String password = "";
    private String database = "";
    private int port = 3050;
    private String host = "localhost";
    private Map listenerMap = Collections.synchronizedMap(new HashMap());
    private Map handlerMap = Collections.synchronizedMap(new HashMap());
    private List eventQueue = new ArrayList();
    private EventDispatcher eventDispatcher;
    private Thread dispatchThread;
    private long waitTimeout = 1000L;

    public FBEventManager() {
        this(GDSFactory.getDefaultGDSType());
    }

    public FBEventManager(GDSType gdsType) {
        this.gds = GDSFactory.getGDSForType(gdsType);
        this.dbHandle = this.gds.createIscDbHandle();
    }

    public void connect() throws SQLException {
        if (this.connected) {
            throw new IllegalStateException("Connect called while already connected");
        }
        DatabaseParameterBuffer dpb = this.gds.createDatabaseParameterBuffer();
        dpb.addArgument(28, this.user);
        dpb.addArgument(29, this.password);
        try {
            String connString = GDSFactory.getDatabasePath(this.gds.getType(), this.host, this.port, this.database);
            this.gds.iscAttachDatabase(connString, this.dbHandle, dpb);
        }
        catch (GDSException e) {
            throw new FBSQLException(e);
        }
        this.connected = true;
        this.eventDispatcher = new EventDispatcher();
        this.dispatchThread = new Thread(this.eventDispatcher);
        this.dispatchThread.setDaemon(true);
        this.dispatchThread.start();
    }

    public void disconnect() throws SQLException {
        if (!this.connected) {
            throw new IllegalStateException("Disconnect called while not connected");
        }
        for (String eventName : new HashSet(this.handlerMap.keySet())) {
            try {
                this.unregisterListener(eventName);
            }
            catch (GDSException e1) {
                throw new FBSQLException(e1);
            }
        }
        this.handlerMap.clear();
        this.listenerMap.clear();
        try {
            this.gds.iscDetachDatabase(this.dbHandle);
        }
        catch (GDSException e2) {
            throw new FBSQLException(e2);
        }
        this.connected = false;
        this.eventDispatcher.stop();
        try {
            this.dispatchThread.join();
        }
        catch (InterruptedException ex) {
            throw new FBSQLException(ex);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getWaitTimeout() {
        return this.waitTimeout;
    }

    public void setWaitTimeout(long waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(String eventName, EventListener listener) throws SQLException {
        if (!this.connected) {
            throw new IllegalStateException("Can't add event listeners to disconnected EventManager");
        }
        if (listener == null || eventName == null) {
            throw new NullPointerException();
        }
        Map map = this.listenerMap;
        synchronized (map) {
            if (!this.listenerMap.containsKey(eventName)) {
                try {
                    this.registerListener(eventName);
                }
                catch (GDSException e) {
                    throw new FBSQLException(e);
                }
                this.listenerMap.put(eventName, new HashSet());
            }
            Set listenerSet = (Set)this.listenerMap.get(eventName);
            listenerSet.add(listener);
        }
    }

    public void removeEventListener(String eventName, EventListener listener) throws SQLException {
        if (eventName == null || listener == null) {
            throw new NullPointerException();
        }
        Set listenerSet = (Set)this.listenerMap.get(eventName);
        if (listenerSet != null) {
            listenerSet.remove(listener);
            if (listenerSet.isEmpty()) {
                this.listenerMap.remove(eventName);
                try {
                    this.unregisterListener(eventName);
                }
                catch (GDSException e) {
                    throw new FBSQLException(e);
                }
            }
        }
    }

    public int waitForEvent(String eventName) throws InterruptedException, SQLException {
        return this.waitForEvent(eventName, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForEvent(String eventName, int timeout) throws InterruptedException, SQLException {
        if (!this.connected) {
            throw new IllegalStateException("Can't wait for events with disconnected EventManager");
        }
        if (eventName == null) {
            throw new NullPointerException();
        }
        Object lock = new Object();
        OneTimeEventListener listener = new OneTimeEventListener(lock);
        Object object = lock;
        synchronized (object) {
            this.addEventListener(eventName, listener);
            lock.wait(timeout);
        }
        this.removeEventListener(eventName, listener);
        return listener.getEventCount();
    }

    private void registerListener(String eventName) throws GDSException {
        GdsEventHandler handler = new GdsEventHandler(eventName);
        this.handlerMap.put(eventName, handler);
        handler.register();
    }

    private void unregisterListener(String eventName) throws GDSException {
        GdsEventHandler handler = (GdsEventHandler)this.handlerMap.get(eventName);
        handler.unregister();
        this.handlerMap.remove(eventName);
    }

    class EventDispatcher
    implements Runnable {
        private volatile boolean running = false;

        EventDispatcher() {
        }

        public void stop() {
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.running = true;
            ArrayList events = new ArrayList();
            while (this.running) {
                List list = FBEventManager.this.eventQueue;
                synchronized (list) {
                    while (FBEventManager.this.eventQueue.isEmpty() && this.running) {
                        try {
                            FBEventManager.this.eventQueue.wait(FBEventManager.this.waitTimeout);
                        }
                        catch (InterruptedException ie) {}
                    }
                    events.addAll(FBEventManager.this.eventQueue);
                    FBEventManager.this.eventQueue.clear();
                }
                for (DatabaseEvent event : events) {
                    Set listenerSet = null;
                    Map map = FBEventManager.this.listenerMap;
                    synchronized (map) {
                        listenerSet = (Set)FBEventManager.this.listenerMap.get(event.getEventName());
                        if (listenerSet != null) {
                            for (EventListener listener : listenerSet) {
                                listener.eventOccurred(event);
                            }
                        }
                    }
                }
                events.clear();
            }
        }
    }

    class GdsEventHandler
    implements EventHandler {
        private EventHandle eventHandle;
        private boolean initialized = false;
        private boolean cancelled = false;

        public GdsEventHandler(String eventName) throws GDSException {
            this.eventHandle = FBEventManager.this.gds.createEventHandle(eventName);
            FBEventManager.this.gds.iscEventBlock(this.eventHandle);
        }

        public synchronized void register() throws GDSException {
            if (this.cancelled) {
                throw new IllegalStateException("Trying to register a cancelled event handler");
            }
            FBEventManager.this.gds.iscQueueEvents(FBEventManager.this.dbHandle, this.eventHandle, this);
        }

        public synchronized void unregister() throws GDSException {
            if (this.cancelled) {
                throw new IllegalStateException("Trying to cancel a cancelled event handler");
            }
            FBEventManager.this.gds.iscCancelEvents(FBEventManager.this.dbHandle, this.eventHandle);
            this.cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void eventOccurred() {
            if (!this.cancelled) {
                try {
                    FBEventManager.this.gds.iscEventCounts(this.eventHandle);
                }
                catch (GDSException e1) {
                    e1.printStackTrace();
                }
                if (this.initialized && !this.cancelled) {
                    DatabaseEventImpl event = new DatabaseEventImpl(this.eventHandle.getEventName(), this.eventHandle.getEventCount());
                    List list = FBEventManager.this.eventQueue;
                    synchronized (list) {
                        FBEventManager.this.eventQueue.add(event);
                        FBEventManager.this.eventQueue.notify();
                    }
                } else {
                    this.initialized = true;
                }
                try {
                    this.register();
                }
                catch (GDSException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }
}

