/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.jni;

import java.io.ByteArrayOutputStream;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.jni.ParameterBufferBase;

class ServiceRequestBufferImp
extends ParameterBufferBase
implements ServiceRequestBuffer {
    private int taskIdentifier;

    ServiceRequestBufferImp(int taskIdentifier) {
        this.taskIdentifier = taskIdentifier;
    }

    public void addArgument(int argumentType, String value) {
        this.getArgumentsList().add(new ParameterBufferBase.StringArgument(argumentType, value){

            protected void writeLength(int length, ByteArrayOutputStream outputStream) {
                outputStream.write(length);
                outputStream.write(length >> 8);
            }
        });
    }

    public void addArgument(int argumentType, int value) {
        this.getArgumentsList().add(new ParameterBufferBase.NumericArgument(argumentType, value){

            protected void writeValue(ByteArrayOutputStream outputStream, int value) {
                outputStream.write(value);
                outputStream.write(value >> 8);
                outputStream.write(value >> 16);
                outputStream.write(value >> 24);
            }
        });
    }

    public void addArgument(int argumentType, byte value) {
        this.getArgumentsList().add(new ParameterBufferBase.NumericArgument(argumentType, value){

            protected void writeValue(ByteArrayOutputStream outputStream, int value) {
                outputStream.write(value);
            }
        });
    }

    byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.taskIdentifier);
        super.writeArgumentsTo(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

