/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscDbHandle;
import org.firebirdsql.gds.IscTrHandle;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.AbstractIscStmtHandle;
import org.firebirdsql.gds.impl.AbstractIscTrHandle;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBStandAloneConnectionManager;
import org.firebirdsql.jca.FBTpb;
import org.firebirdsql.jca.FBXAException;
import org.firebirdsql.jca.FBXid;
import org.firebirdsql.jca.FirebirdLocalTransaction;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBConnectionProperties;
import org.firebirdsql.jdbc.FBDataSource;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;

public class FBManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable,
FirebirdConnectionProperties {
    private static final long serialVersionUID = 7500832904323015501L;
    private static final Map<FBConnectionProperties, SoftReference<FBManagedConnectionFactory>> mcfInstances = new ConcurrentHashMap<FBConnectionProperties, SoftReference<FBManagedConnectionFactory>>();
    private static final ReferenceQueue<FBManagedConnectionFactory> mcfReferenceQueue = new ReferenceQueue();
    private ConnectionManager defaultCm;
    private int hashCode;
    private GDSType gdsType;
    private final transient Map xidMap = Collections.synchronizedMap(new HashMap());
    private final transient Object startLock = new Object();
    private transient boolean started = false;
    private FBConnectionProperties connectionProperties;

    public FBManagedConnectionFactory() {
        this(GDSFactory.getDefaultGDSType(), new FBConnectionProperties());
    }

    public FBManagedConnectionFactory(GDSType gdsType) {
        this(gdsType, new FBConnectionProperties());
    }

    public FBManagedConnectionFactory(GDSType gdsType, FBConnectionProperties connectionProperties) {
        this.defaultCm = new FBStandAloneConnectionManager();
        this.connectionProperties = connectionProperties;
        this.setType(gdsType.toString());
    }

    public GDS getGDS() {
        return GDSFactory.getGDSForType(this.getGDSType());
    }

    public GDSType getGDSType() {
        if (this.gdsType != null) {
            return this.gdsType;
        }
        this.gdsType = GDSType.getType(this.getType());
        return this.gdsType;
    }

    public int getBlobBufferLength() {
        return this.getBlobBufferSize();
    }

    public void setBlobBufferLength(int value) {
        this.setBlobBufferSize(value);
    }

    public Integer getTransactionIsolation() {
        return this.getDefaultTransactionIsolation();
    }

    public void setTransactionIsolation(Integer value) {
        if (value != null) {
            this.setDefaultTransactionIsolation(value);
        }
    }

    public String getTransactionIsolationName() {
        return this.getDefaultIsolation();
    }

    public void setTransactionIsolationName(String name) {
        this.setDefaultIsolation(name);
    }

    public String getLocalEncoding() {
        return this.getCharSet();
    }

    public void setLocalEncoding(String localEncoding) {
        this.setCharSet(localEncoding);
    }

    public int getBlobBufferSize() {
        return this.connectionProperties.getBlobBufferSize();
    }

    public int getBuffersNumber() {
        return this.connectionProperties.getBuffersNumber();
    }

    public String getCharSet() {
        return this.connectionProperties.getCharSet();
    }

    public String getDatabase() {
        return this.connectionProperties.getDatabase();
    }

    public DatabaseParameterBuffer getDatabaseParameterBuffer() throws SQLException {
        return this.connectionProperties.getDatabaseParameterBuffer();
    }

    public String getDefaultIsolation() {
        return this.connectionProperties.getDefaultIsolation();
    }

    public int getDefaultTransactionIsolation() {
        return this.connectionProperties.getDefaultTransactionIsolation();
    }

    public String getEncoding() {
        return this.connectionProperties.getEncoding();
    }

    public String getNonStandardProperty(String key) {
        return this.connectionProperties.getNonStandardProperty(key);
    }

    public String getPassword() {
        return this.connectionProperties.getPassword();
    }

    public String getRoleName() {
        return this.connectionProperties.getRoleName();
    }

    public int getSocketBufferSize() {
        return this.connectionProperties.getSocketBufferSize();
    }

    public String getSqlDialect() {
        return this.connectionProperties.getSqlDialect();
    }

    public String getTpbMapping() {
        return this.connectionProperties.getTpbMapping();
    }

    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        return this.connectionProperties.getTransactionParameters(isolation);
    }

    public String getType() {
        return this.connectionProperties.getType();
    }

    public String getUserName() {
        return this.connectionProperties.getUserName();
    }

    public String getUseTranslation() {
        return this.connectionProperties.getUseTranslation();
    }

    public boolean isTimestampUsesLocalTimezone() {
        return this.connectionProperties.isTimestampUsesLocalTimezone();
    }

    public boolean isUseStandardUdf() {
        return this.connectionProperties.isUseStandardUdf();
    }

    public boolean isUseStreamBlobs() {
        return this.connectionProperties.isUseStreamBlobs();
    }

    public void setBlobBufferSize(int bufferSize) {
        this.connectionProperties.setBlobBufferSize(bufferSize);
    }

    public void setBuffersNumber(int buffersNumber) {
        this.connectionProperties.setBuffersNumber(buffersNumber);
    }

    public void setCharSet(String charSet) {
        this.connectionProperties.setCharSet(charSet);
    }

    public void setDatabase(String database) {
        this.connectionProperties.setDatabase(database);
    }

    public void setDefaultIsolation(String isolation) {
        this.connectionProperties.setDefaultIsolation(isolation);
    }

    public void setDefaultTransactionIsolation(int defaultIsolationLevel) {
        this.connectionProperties.setDefaultTransactionIsolation(defaultIsolationLevel);
    }

    public void setEncoding(String encoding) {
        this.connectionProperties.setEncoding(encoding);
    }

    public void setNonStandardProperty(String key, String value) {
        this.connectionProperties.setNonStandardProperty(key, value);
    }

    public void setNonStandardProperty(String propertyMapping) {
        this.connectionProperties.setNonStandardProperty(propertyMapping);
    }

    public void setPassword(String password) {
        this.connectionProperties.setPassword(password);
    }

    public void setRoleName(String roleName) {
        this.connectionProperties.setRoleName(roleName);
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.connectionProperties.setSocketBufferSize(socketBufferSize);
    }

    public void setSqlDialect(String sqlDialect) {
        this.connectionProperties.setSqlDialect(sqlDialect);
    }

    public void setTimestampUsesLocalTimezone(boolean timestampUsesLocalTimezone) {
        this.connectionProperties.setTimestampUsesLocalTimezone(timestampUsesLocalTimezone);
    }

    public void setTpbMapping(String tpbMapping) {
        this.connectionProperties.setTpbMapping(tpbMapping);
    }

    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        this.connectionProperties.setTransactionParameters(isolation, tpb);
    }

    public void setType(String type) {
        if (this.gdsType != null) {
            throw new IllegalStateException("Cannot change GDS type at runtime.");
        }
        this.connectionProperties.setType(type);
    }

    public void setUserName(String userName) {
        this.connectionProperties.setUserName(userName);
    }

    public void setUseStandardUdf(boolean useStandardUdf) {
        this.connectionProperties.setUseStandardUdf(useStandardUdf);
    }

    public void setUseStreamBlobs(boolean useStreamBlobs) {
        this.connectionProperties.setUseStreamBlobs(useStreamBlobs);
    }

    public void setUseTranslation(String translationPath) {
        this.connectionProperties.setUseTranslation(translationPath);
    }

    public boolean isDefaultResultSetHoldable() {
        return this.connectionProperties.isDefaultResultSetHoldable();
    }

    public void setDefaultResultSetHoldable(boolean isHoldable) {
        this.connectionProperties.setDefaultResultSetHoldable(isHoldable);
    }

    public void setDefaultConnectionManager(ConnectionManager defaultCm) {
        this.defaultCm = defaultCm;
    }

    public int getSoTimeout() {
        return this.connectionProperties.getSoTimeout();
    }

    public void setSoTimeout(int soTimeout) {
        this.connectionProperties.setSoTimeout(soTimeout);
    }

    public int getConnectTimeout() {
        return this.connectionProperties.getConnectTimeout();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectionProperties.setConnectTimeout(connectTimeout);
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int result = 17;
        if ((result = 37 * result + this.connectionProperties.hashCode()) == 0) {
            result = 17;
        }
        if (this.gdsType != null) {
            this.hashCode = result;
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FBManagedConnectionFactory)) {
            return false;
        }
        FBManagedConnectionFactory that = (FBManagedConnectionFactory)other;
        return this.connectionProperties.equals(that.connectionProperties);
    }

    public FBConnectionRequestInfo getDefaultConnectionRequestInfo() throws ResourceException {
        try {
            return new FBConnectionRequestInfo(this.getDatabaseParameterBuffer().deepCopy());
        }
        catch (SQLException ex) {
            throw new FBResourceException(ex);
        }
    }

    public FBTpb getDefaultTpb() throws ResourceException {
        int defaultTransactionIsolation = this.connectionProperties.getMapper().getDefaultTransactionIsolation();
        return this.getTpb(defaultTransactionIsolation);
    }

    public FBTpb getTpb(int defaultTransactionIsolation) throws FBResourceException {
        return new FBTpb(this.connectionProperties.getMapper().getMapping(defaultTransactionIsolation));
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        this.start();
        return new FBDataSource(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        this.start();
        return new FBDataSource(this, this.defaultCm);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        this.start();
        return new FBManagedConnection(subject, cri, this);
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        for (FBManagedConnection mc : connectionSet) {
            if (!mc.matches(subject, (FBConnectionRequestInfo)cxRequestInfo)) continue;
            return mc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        FBManagedConnectionFactory mcf = this.internalCanonicalize();
        if (mcf != null) {
            return mcf;
        }
        mcf = new FBManagedConnectionFactory(this.getGDSType(), (FBConnectionProperties)this.connectionProperties.clone());
        return mcf;
    }

    public FBManagedConnectionFactory canonicalize() {
        FBManagedConnectionFactory mcf = this.internalCanonicalize();
        if (mcf != null) {
            return mcf;
        }
        this.start();
        return this;
    }

    private FBManagedConnectionFactory internalCanonicalize() {
        SoftReference<FBManagedConnectionFactory> factoryReference = mcfInstances.get(this.getCacheKey());
        return factoryReference != null ? factoryReference.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        Object object = this.startLock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            mcfInstances.put(this.getCacheKey(), new SoftReference<FBManagedConnectionFactory>(this, mcfReferenceQueue));
            this.started = true;
        }
        this.cleanMcfInstances();
    }

    private void cleanMcfInstances() {
        Reference<FBManagedConnectionFactory> reference;
        while ((reference = mcfReferenceQueue.poll()) != null) {
            mcfInstances.values().remove(reference);
        }
    }

    void notifyStart(FBManagedConnection mc, Xid xid) throws GDSException {
        this.xidMap.put(xid, mc);
    }

    void notifyEnd(FBManagedConnection mc, Xid xid) throws XAException {
    }

    int notifyPrepare(FBManagedConnection mc, Xid xid) throws GDSException, XAException {
        FBManagedConnection targetMc = (FBManagedConnection)this.xidMap.get(xid);
        if (targetMc == null) {
            throw new FBXAException("Commit called with unknown transaction", -4);
        }
        return targetMc.internalPrepare(xid);
    }

    void notifyCommit(FBManagedConnection mc, Xid xid, boolean onePhase) throws GDSException, XAException {
        FBManagedConnection targetMc = (FBManagedConnection)this.xidMap.get(xid);
        if (targetMc == null) {
            this.tryCompleteInLimboTransaction(this.getGDS(), xid, true);
        } else {
            targetMc.internalCommit(xid, onePhase);
        }
        this.xidMap.remove(xid);
    }

    void notifyRollback(FBManagedConnection mc, Xid xid) throws GDSException, XAException {
        FBManagedConnection targetMc = (FBManagedConnection)this.xidMap.get(xid);
        if (targetMc == null) {
            this.tryCompleteInLimboTransaction(this.getGDS(), xid, false);
        } else {
            targetMc.internalRollback(xid);
        }
        this.xidMap.remove(xid);
    }

    public void forget(FBManagedConnection mc, Xid xid) throws GDSException {
        this.xidMap.remove(xid);
    }

    public void recover(FBManagedConnection mc, Xid xid) throws GDSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryCompleteInLimboTransaction(GDS gds, Xid xid, boolean commit) throws XAException {
        block27: {
            try {
                FBManagedConnection tempMc = null;
                FirebirdLocalTransaction tempLocalTx = null;
                try {
                    tempMc = new FBManagedConnection(null, null, this);
                    tempLocalTx = (FirebirdLocalTransaction)tempMc.getLocalTransaction();
                    tempLocalTx.begin();
                    long fbTransactionId = 0L;
                    boolean found = false;
                    if (tempMc.getGDSHelper().compareToVersion(2, 0) < 0) {
                        FBXid[] inLimboIds = (FBXid[])tempMc.recover(0x1000000);
                        for (int i = 0; i < inLimboIds.length; ++i) {
                            if (!inLimboIds[i].equals(xid)) continue;
                            found = true;
                            fbTransactionId = inLimboIds[i].getFirebirdTransactionId();
                        }
                    } else {
                        FBXid foundXid = (FBXid)tempMc.findSingleXid(xid);
                        if (foundXid != null && foundXid.equals(xid)) {
                            found = true;
                            fbTransactionId = foundXid.getFirebirdTransactionId();
                        }
                    }
                    if (!found) {
                        throw new FBXAException((commit ? "Commit" : "Rollback") + " called with unknown transaction.", -4);
                    }
                    IscDbHandle dbHandle = tempMc.getGDSHelper().getCurrentDbHandle();
                    IscTrHandle trHandle = gds.createIscTrHandle();
                    gds.iscReconnectTransaction(trHandle, dbHandle, fbTransactionId);
                    if (commit) {
                        gds.iscCommitTransaction(trHandle);
                    } else {
                        gds.iscRollbackTransaction(trHandle);
                    }
                    if (tempMc.getGDSHelper().compareToVersion(3, 0) >= 0) break block27;
                    try {
                        String query = "delete from rdb$transactions where rdb$transaction_id = " + fbTransactionId;
                        GDSHelper gdsHelper = new GDSHelper(gds, this.getDatabaseParameterBuffer(), dbHandle, null);
                        AbstractIscTrHandle trHandle2 = (AbstractIscTrHandle)gds.createIscTrHandle();
                        gds.iscStartTransaction(trHandle2, gdsHelper.getCurrentDbHandle(), this.getDefaultTpb().getTransactionParameterBuffer());
                        gdsHelper.setCurrentTrHandle(trHandle2);
                        AbstractIscStmtHandle stmtHandle2 = (AbstractIscStmtHandle)gds.createIscStmtHandle();
                        gds.iscDsqlAllocateStatement(gdsHelper.getCurrentDbHandle(), stmtHandle2);
                        gdsHelper.prepareStatement(stmtHandle2, query, false);
                        gdsHelper.executeStatement(stmtHandle2, false);
                        gdsHelper.closeStatement(stmtHandle2, true);
                        gds.iscCommitTransaction(trHandle2);
                    }
                    catch (SQLException sqle) {
                        throw new FBXAException("unable to remove in limbo transaction from rdb$transactions where rdb$transaction_id = " + fbTransactionId, -3);
                    }
                }
                catch (GDSException ex) {
                    int errorCode = -3;
                    int intParam = ex.getIntParam();
                    int nextIntParam = ex.getNext().getIntParam();
                    if (intParam == 335544353 && nextIntParam == 335544468) {
                        String param = ex.getNext().getNext().getNext().getParam();
                        if ("committed".equals(param)) {
                            errorCode = 7;
                        } else if ("rolled back".equals(param)) {
                            errorCode = 6;
                        }
                    }
                    throw new FBXAException("unable to complete in limbo transaction", errorCode, ex);
                }
                finally {
                    try {
                        if (tempLocalTx != null && tempLocalTx.inTransaction()) {
                            tempLocalTx.commit();
                        }
                    }
                    finally {
                        if (tempMc != null) {
                            tempMc.destroy();
                        }
                    }
                }
            }
            catch (ResourceException ex) {
                throw new FBXAException(-3, (Exception)((Object)ex));
            }
        }
    }

    AbstractConnection newConnection(FBManagedConnection mc) throws ResourceException {
        Class connectionClass = GDSFactory.getConnectionClass(this.getGDSType());
        if (!AbstractConnection.class.isAssignableFrom(connectionClass)) {
            throw new IllegalArgumentException("Specified connection class does not extend " + AbstractConnection.class.getName() + " class");
        }
        try {
            Constructor constructor = connectionClass.getConstructor(FBManagedConnection.class);
            return (AbstractConnection)constructor.newInstance(mc);
        }
        catch (NoSuchMethodException ex) {
            throw new FBResourceException("Cannot instantiate connection class " + connectionClass.getName() + ", no constructor accepting " + FBManagedConnection.class + " class as single parameter was found.");
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)ex.getTargetException();
            }
            if (ex.getTargetException() instanceof Error) {
                throw (Error)ex.getTargetException();
            }
            throw new FBResourceException((Exception)ex.getTargetException());
        }
        catch (IllegalAccessException ex) {
            throw new FBResourceException("Constructor for class " + connectionClass.getName() + " is not accessible.");
        }
        catch (InstantiationException ex) {
            throw new FBResourceException("Cannot instantiate class" + connectionClass.getName());
        }
    }

    public final FBConnectionProperties getCacheKey() {
        return (FBConnectionProperties)this.connectionProperties.clone();
    }
}

